/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.net.InetAddress;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="pathoutage")
public class OnmsPathOutage
implements Serializable {
    private static final long serialVersionUID = 2180867754702562743L;
    private InetAddress m_criticalPathIp;
    private String m_criticalPathServiceName;
    private OnmsNode m_node;

    public OnmsPathOutage(OnmsNode node, InetAddress criticalPathIp, String criticalPathServiceName) {
        this.m_node = node;
        this.m_criticalPathIp = criticalPathIp;
        this.m_criticalPathServiceName = criticalPathServiceName;
    }

    public OnmsPathOutage() {
    }

    @Id
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeid")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="nodeid", nullable=false)
    public int getNodeId() {
        return this.m_node.getId();
    }

    public void setNodeId(int nodeId) {
        this.m_node.setNodeId(String.valueOf(nodeId));
    }

    @Column(name="criticalpathip", nullable=false)
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    public InetAddress getCriticalPathIp() {
        return this.m_criticalPathIp;
    }

    public void setCriticalPathIp(InetAddress criticalPathIp) {
        this.m_criticalPathIp = criticalPathIp;
    }

    @Column(name="criticalpathservicename")
    public String getCriticalPathServiceName() {
        return this.m_criticalPathServiceName;
    }

    public void setCriticalPathServiceName(String criticalPathServiceName) {
        this.m_criticalPathServiceName = criticalPathServiceName;
    }
}

