/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="cdpLink")
public class CdpLink
implements Serializable {
    private static final long serialVersionUID = 3428640531131834328L;
    private Integer m_id;
    private OnmsNode m_node;
    private Integer m_cdpCacheIfIndex;
    private String m_cdpInterfaceName;
    private CiscoNetworkProtocolType m_cdpCacheAddressType;
    private String m_cdpCacheAddress;
    private String m_cdpCacheVersion;
    private String m_cdpCacheDeviceId;
    private String m_cdpCacheDevicePort;
    private String m_cdpCacheDevicePlatform;
    private Date m_cdpLinkCreateTime = new Date();
    private Date m_cdpLinkLastPollTime;

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="cdpCacheIfIndex", nullable=false)
    public Integer getCdpCacheIfIndex() {
        return this.m_cdpCacheIfIndex;
    }

    public void setCdpCacheIfIndex(Integer cdpCacheIfIndex) {
        this.m_cdpCacheIfIndex = cdpCacheIfIndex;
    }

    @Column(name="cdpInterfaceName", length=96, nullable=false)
    public String getCdpInterfaceName() {
        return this.m_cdpInterfaceName;
    }

    public void setCdpInterfaceName(String cdpInterfaceName) {
        this.m_cdpInterfaceName = cdpInterfaceName;
    }

    @Column(name="cdpCacheAddressType", nullable=false)
    @Type(type="org.opennms.netmgt.model.CiscoNetworkProtocolTypeUserType")
    public CiscoNetworkProtocolType getCdpCacheAddressType() {
        return this.m_cdpCacheAddressType;
    }

    public void setCdpCacheAddressType(CiscoNetworkProtocolType cdpCacheAddressType) {
        this.m_cdpCacheAddressType = cdpCacheAddressType;
    }

    @Column(name="cdpCacheAddress", length=64, nullable=false)
    public String getCdpCacheAddress() {
        return this.m_cdpCacheAddress;
    }

    public void setCdpCacheAddress(String cdpCacheAddress) {
        this.m_cdpCacheAddress = cdpCacheAddress;
    }

    @Column(name="cdpCacheVersion", length=256, nullable=false)
    public String getCdpCacheVersion() {
        return this.m_cdpCacheVersion;
    }

    public void setCdpCacheVersion(String cdpCacheVersion) {
        this.m_cdpCacheVersion = cdpCacheVersion;
    }

    @Column(name="cdpCacheDeviceId", length=64, nullable=false)
    public String getCdpCacheDeviceId() {
        return this.m_cdpCacheDeviceId;
    }

    public void setCdpCacheDeviceId(String cdpCacheDeviceId) {
        this.m_cdpCacheDeviceId = cdpCacheDeviceId;
    }

    @Column(name="cdpCacheDevicePort", length=96, nullable=false)
    public String getCdpCacheDevicePort() {
        return this.m_cdpCacheDevicePort;
    }

    public void setCdpCacheDevicePort(String cdpCacheDevicePort) {
        this.m_cdpCacheDevicePort = cdpCacheDevicePort;
    }

    @Column(name="cdpCacheDevicePlatform", length=96, nullable=false)
    public String getCdpCacheDevicePlatform() {
        return this.m_cdpCacheDevicePlatform;
    }

    public void setCdpCacheDevicePlatform(String cdpCacheDevicePlatform) {
        this.m_cdpCacheDevicePlatform = cdpCacheDevicePlatform;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="cdpLinkCreateTime", nullable=false)
    public Date getCdpLinkCreateTime() {
        return this.m_cdpLinkCreateTime;
    }

    public void setCdpLinkCreateTime(Date cdpLinkCreateTime) {
        this.m_cdpLinkCreateTime = cdpLinkCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="cdpLinkLastPollTime", nullable=false)
    public Date getCdpLinkLastPollTime() {
        return this.m_cdpLinkLastPollTime;
    }

    public void setCdpLinkLastPollTime(Date cdpLinkLastPollTime) {
        this.m_cdpLinkLastPollTime = cdpLinkLastPollTime;
    }

    public void merge(CdpLink link) {
        if (link == null) {
            return;
        }
        this.setCdpInterfaceName(link.getCdpInterfaceName());
        this.setCdpCacheAddressType(link.getCdpCacheAddressType());
        this.setCdpCacheAddress(link.getCdpCacheAddress());
        this.setCdpCacheVersion(link.getCdpCacheVersion());
        this.setCdpCacheDeviceId(link.getCdpCacheDeviceId());
        this.setCdpCacheDevicePort(link.getCdpCacheDevicePort());
        this.setCdpCacheDevicePlatform(link.getCdpCacheDevicePlatform());
        this.setCdpLinkLastPollTime(link.getCdpLinkCreateTime());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("NodeId", (Object)this.m_node.getId()).append("cdpCacheIfIndex", (Object)this.m_cdpCacheIfIndex).append("cdpInterfaceName", (Object)this.m_cdpInterfaceName).append("cdpCacheAddressType", (Object)CiscoNetworkProtocolType.getTypeString(this.m_cdpCacheAddressType.getValue())).append("cdpCacheAddress", (Object)this.m_cdpCacheAddress).append("cdpCacheVersion", (Object)this.m_cdpCacheVersion).append("cdpCachedeviceId", (Object)this.m_cdpCacheDeviceId).append("cdpCachedevicePort", (Object)this.m_cdpCacheDevicePort).append("cdpCachedevicePlatform", (Object)this.m_cdpCacheDevicePlatform).append("createTime", (Object)this.m_cdpLinkCreateTime).append("lastPollTime", (Object)this.m_cdpLinkLastPollTime).toString();
    }

    public static enum CiscoNetworkProtocolType {
        ip(1),
        decnet(2),
        pup(3),
        chaos(4),
        xns(5),
        x121(6),
        appletalk(7),
        clns(8),
        lat(9),
        vines(10),
        cons(11),
        apollo(12),
        stun(13),
        novell(14),
        qllc(15),
        snapshot(16),
        atmIlmi(17),
        bstun(18),
        x25pvc(19),
        ipv6(20),
        cdm(21),
        nbf(22),
        bpxIgx(23),
        clnsPfx(24),
        http(25),
        unknown(65535);

        private int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private CiscoNetworkProtocolType(Integer chassisIdsubtype) {
            this.m_type = chassisIdsubtype;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public static CiscoNetworkProtocolType get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create CiscoNetworkProtocolType from null code");
            }
            switch (code) {
                case 1: {
                    return ip;
                }
                case 2: {
                    return decnet;
                }
                case 3: {
                    return pup;
                }
                case 4: {
                    return chaos;
                }
                case 5: {
                    return xns;
                }
                case 6: {
                    return x121;
                }
                case 7: {
                    return appletalk;
                }
                case 8: {
                    return clns;
                }
                case 9: {
                    return lat;
                }
                case 10: {
                    return vines;
                }
                case 11: {
                    return cons;
                }
                case 12: {
                    return apollo;
                }
                case 13: {
                    return stun;
                }
                case 14: {
                    return novell;
                }
                case 15: {
                    return qllc;
                }
                case 16: {
                    return snapshot;
                }
                case 17: {
                    return atmIlmi;
                }
                case 18: {
                    return bstun;
                }
                case 19: {
                    return x25pvc;
                }
                case 20: {
                    return ipv6;
                }
                case 21: {
                    return cdm;
                }
                case 22: {
                    return nbf;
                }
                case 23: {
                    return bpxIgx;
                }
                case 24: {
                    return clnsPfx;
                }
                case 25: {
                    return http;
                }
                case 65535: {
                    return unknown;
                }
            }
            throw new IllegalArgumentException("Cannot create CiscoNetworkProtocolType from code " + code);
        }

        public Integer getValue() {
            return this.m_type;
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "ip");
            s_typeMap.put(2, "decnet");
            s_typeMap.put(3, "pup");
            s_typeMap.put(4, "chaos");
            s_typeMap.put(5, "xns");
            s_typeMap.put(6, "x121");
            s_typeMap.put(7, "appletalk");
            s_typeMap.put(8, "clns");
            s_typeMap.put(9, "lat");
            s_typeMap.put(10, "vines");
            s_typeMap.put(11, "cons");
            s_typeMap.put(12, "apollo");
            s_typeMap.put(13, "stun");
            s_typeMap.put(14, "novell");
            s_typeMap.put(15, "qllc");
            s_typeMap.put(16, "snapshot");
            s_typeMap.put(17, "atmIlmi");
            s_typeMap.put(18, "bstun");
            s_typeMap.put(19, "x25pvc");
            s_typeMap.put(20, "ipv6");
            s_typeMap.put(21, "cdm");
            s_typeMap.put(22, "nbf");
            s_typeMap.put(23, "bpxIgx");
            s_typeMap.put(24, "clnsPfx");
            s_typeMap.put(25, "http");
            s_typeMap.put(65535, "unknown");
        }
    }
}

