/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.LazySet;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.LocationMonitorIpInterface;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedStatusResourceType
implements OnmsResourceType {
    public static final String DISTRIBUTED_DIRECTORY = "distributed";
    private ResourceDao m_resourceDao;
    private LocationMonitorDao m_locationMonitorDao;

    public DistributedStatusResourceType(ResourceDao resourceDao, LocationMonitorDao locationMonitorDao) {
        this.m_resourceDao = resourceDao;
        this.m_locationMonitorDao = locationMonitorDao;
    }

    public String getLabel() {
        return "Distributed Status";
    }

    public String getName() {
        return "distributedStatus";
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        return Collections.EMPTY_LIST;
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        LinkedList<OnmsResource> resources = new LinkedList<OnmsResource>();
        Collection<LocationMonitorIpInterface> statuses = this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(nodeId);
        for (LocationMonitorIpInterface status : statuses) {
            String ipAddr;
            String definitionName = status.getLocationMonitor().getDefinitionName();
            int id = status.getLocationMonitor().getId();
            File iface = this.getInterfaceDirectory(id, ipAddr = status.getIpInterface().getIpAddress());
            if (!iface.isDirectory()) continue;
            resources.add(this.createResource(definitionName, id, ipAddr));
        }
        return OnmsResource.sortIntoResourceList(resources);
    }

    public List<OnmsResource> getResourcesForLocationMonitor(int locationMonitorId) {
        File locationMonitorDirectory;
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        try {
            locationMonitorDirectory = this.getLocationMonitorDirectory(locationMonitorId, true);
        }
        catch (DataAccessException e) {
            throw new ObjectRetrievalFailureException("The '" + this.getName() + "' resource type does not exist on this location Monitor.  Nested exception is: " + ((Object)((Object)e)).getClass().getName() + ": " + e.getMessage(), (Throwable)e);
        }
        File[] intfDirs = locationMonitorDirectory.listFiles(RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        if (intfDirs == null) {
            return resources;
        }
        for (File intfDir : intfDirs) {
            String d = intfDir.getName();
            String defName = this.getDefinitionNameFromLocationMonitorDirectory(d);
            int id = this.getLocationMonitorIdFromLocationMonitorDirectory(d);
            resources.add(this.createResource(defName, id, intfDir.getName()));
        }
        return resources;
    }

    private OnmsResource createResource(String definitionName, int locationMonitorId, String intf) {
        String monitor = definitionName + "-" + locationMonitorId;
        String label = intf + " from " + monitor;
        String resource = locationMonitorId + File.separator + intf;
        LazySet set = new LazySet((LazySet.Loader)new AttributeLoader(definitionName, locationMonitorId, intf));
        return new OnmsResource(resource, label, (OnmsResourceType)this, (Set)set);
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return false;
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return this.getResourcesForNode(nodeId).size() > 0;
    }

    private String getDefinitionNameFromLocationMonitorDirectory(String dir) {
        int index = dir.indexOf("-");
        if (index == -1) {
            throw new IllegalArgumentException("Location monitor directory \"" + dir + "\" isn't a valid " + "location monitor directory");
        }
        return dir.substring(0, index);
    }

    private int getLocationMonitorIdFromLocationMonitorDirectory(String dir) {
        int index = dir.indexOf("-");
        if (index == -1) {
            throw new IllegalArgumentException("Location monitor directory \"" + dir + "\" isn't a valid " + "location monitor directory");
        }
        return Integer.parseInt(dir.substring(index + 1));
    }

    public File getInterfaceDirectory(int id, String ipAddr) {
        return new File(this.m_resourceDao.getRrdDirectory(), this.getRelativeInterfacePath(id, ipAddr));
    }

    public String getRelativeInterfacePath(int id, String ipAddr) {
        return "response" + File.separator + DISTRIBUTED_DIRECTORY + File.separator + Integer.toString(id) + File.separator + ipAddr;
    }

    private File getLocationMonitorDirectory(int locationMonitorId, boolean verify) throws ObjectRetrievalFailureException {
        return this.getLocationMonitorDirectory(Integer.toString(locationMonitorId), verify);
    }

    private File getLocationMonitorDirectory(String locationMonitorId, boolean verify) throws ObjectRetrievalFailureException {
        File locationMonitorDirectory = new File(this.m_resourceDao.getRrdDirectory(verify), locationMonitorId);
        if (verify && !locationMonitorDirectory.isDirectory()) {
            throw new ObjectRetrievalFailureException(File.class, (Object)("No node directory exists for node " + locationMonitorId + ": " + locationMonitorDirectory));
        }
        return locationMonitorDirectory;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance();
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeLoader
    implements LazySet.Loader<OnmsAttribute> {
        private String m_definitionName;
        private int m_locationMonitorId;
        private String m_intf;

        public AttributeLoader(String definitionName, int locationMonitorId, String intf) {
            this.m_definitionName = definitionName;
            this.m_locationMonitorId = locationMonitorId;
            this.m_intf = intf;
        }

        public Set<OnmsAttribute> load() {
            if (DistributedStatusResourceType.this.log().isDebugEnabled()) {
                DistributedStatusResourceType.this.log().debug("lazy-loading attributes for distributed status resource " + this.m_definitionName + "-" + this.m_locationMonitorId + "/" + this.m_intf);
            }
            return ResourceTypeUtils.getAttributesAtRelativePath(DistributedStatusResourceType.this.m_resourceDao.getRrdDirectory(), DistributedStatusResourceType.this.getRelativeInterfacePath(this.m_locationMonitorId, this.m_intf));
        }
    }
}

