/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opennms.netmgt.model.AttributeStatistic;
import org.opennms.netmgt.model.AttributeStatisticVisitorWithResults;
import org.opennms.netmgt.model.OnmsAttribute;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BottomNAttributeStatisticVisitor
implements AttributeStatisticVisitorWithResults,
InitializingBean {
    private Integer m_count;
    private SortedSet<AttributeStatistic> m_results = new TreeSet<AttributeStatistic>(new AttributeStatisticComparator());
    protected Comparator<Double> m_comparator = new DoubleComparator();

    public void visit(OnmsAttribute attribute, double statistic) {
        Assert.notNull((Object)attribute, (String)"attribute argument must not be null");
        this.m_results.add(new AttributeStatistic(attribute, Double.valueOf(statistic)));
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_count != null ? 1 : 0) != 0, (String)"property count must be set to a non-null value");
    }

    public Integer getCount() {
        return this.m_count;
    }

    public void setCount(Integer count) {
        this.m_count = count;
    }

    public SortedSet<AttributeStatistic> getResults() {
        TreeSet<AttributeStatistic> top = new TreeSet<AttributeStatistic>(new AttributeStatisticComparator());
        for (AttributeStatistic stat : this.m_results) {
            top.add(stat);
            if (top.size() < this.m_count) continue;
            break;
        }
        return top;
    }

    public Comparator<Double> getComparator() {
        return this.m_comparator;
    }

    public void setComparator(Comparator<Double> comparator) {
        this.m_comparator = comparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DoubleComparator
    implements Comparator<Double> {
        @Override
        public int compare(Double o1, Double o2) {
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeStatisticComparator
    implements Comparator<AttributeStatistic> {
        @Override
        public int compare(AttributeStatistic o1, AttributeStatistic o2) {
            int diff = BottomNAttributeStatisticVisitor.this.getComparator().compare(o1.getStatistic(), o2.getStatistic());
            if (diff != 0) {
                return diff;
            }
            diff = o1.getAttribute().getResource().getId().compareToIgnoreCase(o2.getAttribute().getResource().getId());
            if (diff != 0) {
                return diff;
            }
            return new Integer(o1.getAttribute().hashCode()).compareTo(o2.getAttribute().hashCode());
        }
    }
}

