/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.config.databaseReports.DatabaseReports;
import org.opennms.netmgt.config.databaseReports.Report;
import org.opennms.netmgt.dao.DatabaseReportConfigDao;
import org.opennms.netmgt.dao.castor.AbstractCastorConfigDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDatabaseReportConfigDao
extends AbstractCastorConfigDao<DatabaseReports, List<Report>>
implements DatabaseReportConfigDao {
    public DefaultDatabaseReportConfigDao() {
        super(DatabaseReports.class, "Database Report Configuration");
    }

    @Override
    public List<Report> translateConfig(DatabaseReports castorConfig) {
        return Collections.unmodifiableList(castorConfig.getReportCollection());
    }

    @Override
    public String getReportService(String name) {
        Report report = this.getReport(name);
        if (report != null) {
            return report.getReportService();
        }
        return new String();
    }

    @Override
    public String getDisplayName(String name) {
        Report report = this.getReport(name);
        if (report != null) {
            return report.getDisplayName();
        }
        return new String();
    }

    private Report getReport(String name) {
        for (Report report : (List)this.getContainer().getObject()) {
            if (!name.equals(report.getId())) continue;
            return report;
        }
        return null;
    }

    @Override
    public List<Report> getReports() {
        return (List)this.getContainer().getObject();
    }

    @Override
    public List<Report> getOnlineReports() {
        ArrayList<Report> onlineReports = new ArrayList<Report>();
        for (Report report : (List)this.getContainer().getObject()) {
            if (!report.isOnline()) continue;
            onlineReports.add(report);
        }
        return onlineReports;
    }
}

