/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.dao.castor.DefaultDataCollectionConfigDao;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class DataCollectionConfigFactory {
    private static DataCollectionConfig m_singleton = null;

    public static void setInstance(DataCollectionConfig instance) {
        m_singleton = instance;
    }

    public static synchronized void init() throws IOException {
        if (m_singleton == null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DATA_COLLECTION_CONF_FILE_NAME);
            DefaultDataCollectionConfigDao dataCollectionDao = new DefaultDataCollectionConfigDao();
            dataCollectionDao.setConfigResource((Resource)new FileSystemResource(cfgFile));
            dataCollectionDao.afterPropertiesSet();
            DataCollectionConfigFactory.setInstance(dataCollectionDao);
            m_singleton = dataCollectionDao;
        }
    }

    public static synchronized void reload() throws IOException {
        m_singleton = null;
        DataCollectionConfigFactory.init();
    }

    public static synchronized DataCollectionConfig getInstance() {
        if (m_singleton == null) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static void main(String[] args) {
        try {
            DataCollectionConfigFactory.init();
            DataCollectionConfig config = DataCollectionConfigFactory.getInstance();
            if (config == null) {
                System.err.println("ERROR: can't get a reference to DataCollectionConfig object");
            } else {
                config.getConfiguredResourceTypes();
                System.out.println("OK: no errors found");
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
        }
    }
}

