/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.opennms.core.utils.ByteArrayComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InetAddressUtils {
    public static InetAddress getInetAddress(byte[] ipAddrOctets) {
        try {
            return InetAddress.getByAddress(ipAddrOctets);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IPAddress " + ipAddrOctets + " with length " + ipAddrOctets.length);
        }
    }

    public static InetAddress getInetAddress(String dottedNotation) {
        try {
            return InetAddress.getByName(dottedNotation);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IPAddress " + dottedNotation);
        }
    }

    public static InetAddress getInetAddress(long ipAddrAs32bitNumber) {
        return InetAddressUtils.getInetAddress(InetAddressUtils.toIpAddrBytes(ipAddrAs32bitNumber));
    }

    public static byte[] toIpAddrBytes(long address) {
        byte[] octets = new byte[]{(byte)(address >>> 24 & 0xFFL), (byte)(address >>> 16 & 0xFFL), (byte)(address >>> 8 & 0xFFL), (byte)(address & 0xFFL)};
        return octets;
    }

    public static byte[] toIpAddrBytes(String dottedNotation) {
        return InetAddressUtils.getInetAddress(dottedNotation).getAddress();
    }

    public static long toIpAddrLong(byte[] address) {
        if (address.length != 4) {
            throw new IllegalArgumentException("address " + address + " has the wrong length " + address.length);
        }
        long[] octets = new long[address.length];
        octets[0] = InetAddressUtils.unsignedByteToLong(address[0]);
        octets[1] = InetAddressUtils.unsignedByteToLong(address[1]);
        octets[2] = InetAddressUtils.unsignedByteToLong(address[2]);
        octets[3] = InetAddressUtils.unsignedByteToLong(address[3]);
        long result = octets[0] << 24 | octets[1] << 16 | octets[2] << 8 | octets[3];
        return result;
    }

    public static long toIpAddrLong(String dottedNotation) {
        return InetAddressUtils.toIpAddrLong(InetAddressUtils.toIpAddrBytes(dottedNotation));
    }

    public static long toIpAddrLong(InetAddress addr) {
        return InetAddressUtils.toIpAddrLong(addr.getAddress());
    }

    private static long unsignedByteToLong(byte b) {
        return b < 0 ? (long)b + 256L : (long)b;
    }

    public static String toIpAddrString(long ipAddr) {
        return InetAddressUtils.getInetAddress(ipAddr).getHostAddress();
    }

    public static String toIpAddrString(byte[] addr) {
        return InetAddressUtils.getInetAddress(addr).getHostAddress();
    }

    public static InetAddress getLowestInetAddress(List<InetAddress> addresses) {
        byte[] originalBytes;
        if (addresses == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        InetAddress lowest = null;
        byte[] lowestBytes = originalBytes = InetAddressUtils.toIpAddrBytes("ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        ByteArrayComparator comparator = new ByteArrayComparator();
        for (InetAddress temp : addresses) {
            byte[] tempBytes = temp.getAddress();
            if (comparator.compare(tempBytes, lowestBytes) >= 0) continue;
            lowestBytes = tempBytes;
            lowest = temp;
        }
        return comparator.compare(originalBytes, lowestBytes) == 0 ? null : lowest;
    }

    public static boolean isInetAddressInRange(String addrString, String beginString, String endString) {
        byte[] begin;
        ByteArrayComparator comparator = new ByteArrayComparator();
        byte[] addr = InetAddressUtils.toIpAddrBytes(addrString);
        if (comparator.compare(addr, begin = InetAddressUtils.toIpAddrBytes(beginString)) > 0) {
            byte[] end = InetAddressUtils.toIpAddrBytes(endString);
            return comparator.compare(addr, end) <= 0;
        }
        return comparator.compare(addr, begin) == 0;
    }

    public static boolean isInetAddressInRange(byte[] addr, byte[] begin, byte[] end) {
        ByteArrayComparator comparator = new ByteArrayComparator();
        if (comparator.compare(addr, begin) > 0) {
            return comparator.compare(addr, end) <= 0;
        }
        return comparator.compare(addr, begin) == 0;
    }

    public static InetAddress convertBigIntegerIntoInetAddress(BigInteger i) throws UnknownHostException {
        if (i.compareTo(new BigInteger("0")) < 0) {
            throw new IllegalArgumentException("BigInteger is negative, cannot convert into an IP address: " + i.toString());
        }
        byte[] bytes = i.toByteArray();
        if (bytes.length == 0) {
            return InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
        }
        if (bytes.length <= 4) {
            byte[] addressBytes = new byte[4];
            int k = 3;
            int j = bytes.length - 1;
            while (j >= 0) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        if (bytes.length <= 5 && bytes[0] == 0) {
            byte[] addressBytes = new byte[4];
            int k = 3;
            int j = bytes.length - 1;
            while (j >= 1) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        if (bytes.length <= 16) {
            byte[] addressBytes = new byte[16];
            int k = 15;
            int j = bytes.length - 1;
            while (j >= 0) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        if (bytes.length <= 17 && bytes[0] == 0) {
            byte[] addressBytes = new byte[16];
            int k = 15;
            int j = bytes.length - 1;
            while (j >= 1) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        throw new IllegalArgumentException("BigInteger is too large to convert into an IP address: " + i.toString());
    }
}

