/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.events;

import java.util.Collection;
import java.util.Date;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.AlarmData;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBuilder {
    private Event m_event;

    public EventBuilder(String uei, String source) {
        this(uei, source, new Date());
    }

    public EventBuilder(String uei, String source, Date date) {
        this.m_event = new Event();
        this.m_event.setUei(uei);
        this.setTime(date);
        this.setCreationTime(date);
        this.setSource(source);
    }

    public EventBuilder(Event event) {
        this(event, new Date());
    }

    public EventBuilder(Event event, String source) {
        this(event);
        this.setSource(source);
    }

    public EventBuilder(Event event, Date date) {
        this.m_event = event;
        this.setSource(event.getSource());
        this.setTime(date);
        this.setCreationTime(date);
    }

    public Event getEvent() {
        return this.m_event;
    }

    public EventBuilder setTime(Date date) {
        this.m_event.setTime(EventConstants.formatToString(date));
        return this;
    }

    public EventBuilder setCreationTime(Date date) {
        this.m_event.setCreationTime(EventConstants.formatToString(date));
        return this;
    }

    public EventBuilder setSource(String source) {
        this.m_event.setSource(source);
        return this;
    }

    public EventBuilder setSeverity(String severity) {
        this.m_event.setSeverity(OnmsSeverity.get(severity).getLabel());
        return this;
    }

    public EventBuilder setNodeid(int nodeid) {
        this.m_event.setNodeid(nodeid);
        return this;
    }

    public EventBuilder setHost(String hostname) {
        this.m_event.setHost(hostname);
        return this;
    }

    public EventBuilder setInterface(String ipAddress) {
        this.m_event.setInterface(ipAddress);
        return this;
    }

    public EventBuilder setService(String serviceName) {
        this.m_event.setService(serviceName);
        return this;
    }

    public EventBuilder addParam(String parmName, String val) {
        if (parmName != null) {
            Value value = new Value();
            value.setContent(val);
            Parm parm = new Parm();
            parm.setParmName(parmName);
            parm.setValue(value);
            if (this.m_event.getParms() == null) {
                Parms parms = new Parms();
                this.m_event.setParms(parms);
            }
            this.m_event.getParms().addParm(parm);
        }
        return this;
    }

    public EventBuilder setParam(String parmName, String val) {
        Parms parms = this.m_event.getParms();
        if (parms == null) {
            return this.addParam(parmName, val);
        }
        for (Parm parm : parms.getParmCollection()) {
            if (!parm.getParmName().equals(val)) continue;
            Value value = new Value();
            value.setContent(val);
            parm.setValue(value);
            return this;
        }
        return this.addParam(parmName, val);
    }

    public EventBuilder addParam(String parmName, long val) {
        return this.addParam(parmName, Long.toString(val));
    }

    public EventBuilder addParam(String parmName, int val) {
        return this.addParam(parmName, Integer.toString(val));
    }

    public EventBuilder addParam(String parmName, char ch) {
        return this.addParam(parmName, Character.toString(ch));
    }

    public EventBuilder addParam(String parmName, Collection<String> vals) {
        String val = StringUtils.collectionToCommaDelimitedString(vals);
        return this.addParam(parmName, val);
    }

    public EventBuilder setAlarmData(AlarmData alarmData) {
        if (alarmData != null) {
            this.m_event.setAlarmData(alarmData);
        }
        return this;
    }

    public EventBuilder setNode(OnmsNode node) {
        if (node != null) {
            this.m_event.setNodeid(node.getId().longValue());
        }
        return this;
    }

    public EventBuilder setIpInterface(OnmsIpInterface iface) {
        if (iface != null) {
            if (iface.getNode() != null) {
                this.m_event.setNodeid(iface.getNode().getId().longValue());
            }
            this.m_event.setInterface(iface.getIpAddress());
        }
        return this;
    }

    public EventBuilder setMonitoredService(OnmsMonitoredService monitoredService) {
        if (monitoredService != null) {
            this.m_event.setNodeid(monitoredService.getNodeId().longValue());
            this.m_event.setInterface(monitoredService.getIpAddress());
            this.m_event.setService(monitoredService.getServiceName());
        }
        return this;
    }

    public EventBuilder setSnmpVersion(String version) {
        this.ensureSnmp();
        this.m_event.getSnmp().setVersion(version);
        return this;
    }

    private void ensureSnmp() {
        if (this.m_event.getSnmp() == null) {
            this.m_event.setSnmp(new Snmp());
        }
    }

    public EventBuilder setEnterpriseId(String enterprise) {
        this.ensureSnmp();
        this.m_event.getSnmp().setId(enterprise);
        return this;
    }

    public EventBuilder setGeneric(int generic) {
        this.ensureSnmp();
        this.m_event.getSnmp().setGeneric(generic);
        return this;
    }

    public EventBuilder setSpecific(int specific) {
        this.ensureSnmp();
        this.m_event.getSnmp().setSpecific(specific);
        return this;
    }

    public EventBuilder setSnmpHost(String snmpHost) {
        this.m_event.setSnmphost(snmpHost);
        return this;
    }

    public void setField(String name, String val) {
        if (name.equals("eventparms")) {
            String[] parts;
            for (String part : parts = val.split(";")) {
                String[] pair = part.split("=");
                this.addParam(pair[0], pair[1].replaceFirst("[(]\\w+,\\w+[)]", ""));
            }
        } else {
            BeanWrapperImpl w = new BeanWrapperImpl((Object)this.m_event);
            try {
                w.setPropertyValue(name, (Object)val);
            }
            catch (BeansException e) {
                ThreadCategory.getInstance(this.getClass()).warn("Could not set field on event: " + name, (Throwable)e);
            }
        }
    }

    private void ensureLogmsg() {
        if (this.m_event.getLogmsg() == null) {
            this.m_event.setLogmsg(new Logmsg());
        }
    }

    public EventBuilder setLogDest(String dest) {
        this.ensureLogmsg();
        this.m_event.getLogmsg().setDest(dest);
        return this;
    }

    public EventBuilder setLogMessage(String content) {
        this.ensureLogmsg();
        this.m_event.getLogmsg().setContent(content);
        return this;
    }

    public EventBuilder setDescription(String descr) {
        this.m_event.setDescr(descr);
        return this;
    }

    public EventBuilder addParms(Parms parms) {
        this.m_event.setParms(parms);
        return this;
    }
}

