/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.springframework.core.style.ToStringCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="applications")
public class OnmsApplication
implements Comparable<OnmsApplication> {
    private Integer m_id;
    private String m_name;
    private Set<OnmsMonitoredService> m_monitoredServices = new LinkedHashSet<OnmsMonitoredService>();

    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @Column(name="name", length=32, nullable=false, unique=true)
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @ManyToMany(mappedBy="applications", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public Set<OnmsMonitoredService> getMonitoredServices() {
        return this.m_monitoredServices;
    }

    public void setMonitoredServices(Set<OnmsMonitoredService> services) {
        this.m_monitoredServices = services;
    }

    public void addMonitoredService(OnmsMonitoredService service) {
        this.getMonitoredServices().add(service);
    }

    @Override
    public int compareTo(OnmsApplication o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public String toString() {
        ToStringCreator creator = new ToStringCreator((Object)this);
        creator.append("id", (Object)this.getId());
        creator.append("name", (Object)this.getName());
        return creator.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OnmsApplication) {
            OnmsApplication app = (OnmsApplication)obj;
            return this.getName().equals(app.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

