/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.threshd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Thresholder;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreshdConfiguration
implements Serializable {
    private int _threads;
    private boolean _has_threads;
    private List<Package> _packageList = new ArrayList<Package>();
    private List<Thresholder> _thresholderList = new ArrayList<Thresholder>();

    public void addPackage(Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(vPackage);
    }

    public void addPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(index, vPackage);
    }

    public void addThresholder(Thresholder vThresholder) throws IndexOutOfBoundsException {
        this._thresholderList.add(vThresholder);
    }

    public void addThresholder(int index, Thresholder vThresholder) throws IndexOutOfBoundsException {
        this._thresholderList.add(index, vThresholder);
    }

    public void deleteThreads() {
        this._has_threads = false;
    }

    public Enumeration<Package> enumeratePackage() {
        return Collections.enumeration(this._packageList);
    }

    public Enumeration<Thresholder> enumerateThresholder() {
        return Collections.enumeration(this._thresholderList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ThreshdConfiguration) {
            ThreshdConfiguration temp = (ThreshdConfiguration)obj;
            if (this._threads != temp._threads) {
                return false;
            }
            if (this._has_threads != temp._has_threads) {
                return false;
            }
            if (this._packageList != null) {
                if (temp._packageList == null) {
                    return false;
                }
                if (!((Object)this._packageList).equals(temp._packageList)) {
                    return false;
                }
            } else if (temp._packageList != null) {
                return false;
            }
            if (this._thresholderList != null) {
                if (temp._thresholderList == null) {
                    return false;
                }
                if (!((Object)this._thresholderList).equals(temp._thresholderList)) {
                    return false;
                }
            } else if (temp._thresholderList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Package getPackage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("getPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        return this._packageList.get(index);
    }

    public Package[] getPackage() {
        Package[] array = new Package[]{};
        return this._packageList.toArray(array);
    }

    public List<Package> getPackageCollection() {
        return this._packageList;
    }

    public int getPackageCount() {
        return this._packageList.size();
    }

    public int getThreads() {
        return this._threads;
    }

    public Thresholder getThresholder(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._thresholderList.size()) {
            throw new IndexOutOfBoundsException("getThresholder: Index value '" + index + "' not in range [0.." + (this._thresholderList.size() - 1) + "]");
        }
        return this._thresholderList.get(index);
    }

    public Thresholder[] getThresholder() {
        Thresholder[] array = new Thresholder[]{};
        return this._thresholderList.toArray(array);
    }

    public List<Thresholder> getThresholderCollection() {
        return this._thresholderList;
    }

    public int getThresholderCount() {
        return this._thresholderList.size();
    }

    public boolean hasThreads() {
        return this._has_threads;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this._threads;
        if (this._packageList != null) {
            result = 37 * result + ((Object)this._packageList).hashCode();
        }
        if (this._thresholderList != null) {
            result = 37 * result + ((Object)this._thresholderList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Package> iteratePackage() {
        return this._packageList.iterator();
    }

    public Iterator<Thresholder> iterateThresholder() {
        return this._thresholderList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllPackage() {
        this._packageList.clear();
    }

    public void removeAllThresholder() {
        this._thresholderList.clear();
    }

    public boolean removePackage(Package vPackage) {
        boolean removed = this._packageList.remove(vPackage);
        return removed;
    }

    public Package removePackageAt(int index) {
        Package obj = this._packageList.remove(index);
        return obj;
    }

    public boolean removeThresholder(Thresholder vThresholder) {
        boolean removed = this._thresholderList.remove(vThresholder);
        return removed;
    }

    public Thresholder removeThresholderAt(int index) {
        Thresholder obj = this._thresholderList.remove(index);
        return obj;
    }

    public void setPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("setPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        this._packageList.set(index, vPackage);
    }

    public void setPackage(Package[] vPackageArray) {
        this._packageList.clear();
        for (int i = 0; i < vPackageArray.length; ++i) {
            this._packageList.add(vPackageArray[i]);
        }
    }

    public void setPackage(List<Package> vPackageList) {
        this._packageList.clear();
        this._packageList.addAll(vPackageList);
    }

    public void setPackageCollection(List<Package> _packageList) {
        this._packageList = _packageList;
    }

    public void setThreads(int threads) {
        this._threads = threads;
        this._has_threads = true;
    }

    public void setThresholder(int index, Thresholder vThresholder) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._thresholderList.size()) {
            throw new IndexOutOfBoundsException("setThresholder: Index value '" + index + "' not in range [0.." + (this._thresholderList.size() - 1) + "]");
        }
        this._thresholderList.set(index, vThresholder);
    }

    public void setThresholder(Thresholder[] vThresholderArray) {
        this._thresholderList.clear();
        for (int i = 0; i < vThresholderArray.length; ++i) {
            this._thresholderList.add(vThresholderArray[i]);
        }
    }

    public void setThresholder(List<Thresholder> vThresholderList) {
        this._thresholderList.clear();
        this._thresholderList.addAll(vThresholderList);
    }

    public void setThresholderCollection(List<Thresholder> thresholderList) {
        this._thresholderList = thresholderList;
    }

    public static ThreshdConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (ThreshdConfiguration)Unmarshaller.unmarshal(ThreshdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

