/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.map.adapter;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.map.adapter.Cmaps;
import org.opennms.netmgt.config.map.adapter.Package;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapsAdapterConfiguration
implements Serializable {
    private int _elementDimension;
    private boolean _has_elementDimension;
    private List<Package> _packageList = new ArrayList<Package>();
    private Cmaps _cmaps;

    public void addPackage(Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(vPackage);
    }

    public void addPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(index, vPackage);
    }

    public void deleteElementDimension() {
        this._has_elementDimension = false;
    }

    public Enumeration<Package> enumeratePackage() {
        return Collections.enumeration(this._packageList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MapsAdapterConfiguration) {
            MapsAdapterConfiguration temp = (MapsAdapterConfiguration)obj;
            if (this._elementDimension != temp._elementDimension) {
                return false;
            }
            if (this._has_elementDimension != temp._has_elementDimension) {
                return false;
            }
            if (this._packageList != null) {
                if (temp._packageList == null) {
                    return false;
                }
                if (!((Object)this._packageList).equals(temp._packageList)) {
                    return false;
                }
            } else if (temp._packageList != null) {
                return false;
            }
            if (this._cmaps != null) {
                if (temp._cmaps == null) {
                    return false;
                }
                if (!this._cmaps.equals(temp._cmaps)) {
                    return false;
                }
            } else if (temp._cmaps != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Cmaps getCmaps() {
        return this._cmaps;
    }

    public int getElementDimension() {
        return this._elementDimension;
    }

    public Package getPackage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("getPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        return this._packageList.get(index);
    }

    public Package[] getPackage() {
        Package[] array = new Package[]{};
        return this._packageList.toArray(array);
    }

    public List<Package> getPackageCollection() {
        return this._packageList;
    }

    public int getPackageCount() {
        return this._packageList.size();
    }

    public boolean hasElementDimension() {
        return this._has_elementDimension;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this._elementDimension;
        if (this._packageList != null) {
            result = 37 * result + ((Object)this._packageList).hashCode();
        }
        if (this._cmaps != null) {
            result = 37 * result + this._cmaps.hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Package> iteratePackage() {
        return this._packageList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllPackage() {
        this._packageList.clear();
    }

    public boolean removePackage(Package vPackage) {
        boolean removed = this._packageList.remove(vPackage);
        return removed;
    }

    public Package removePackageAt(int index) {
        Package obj = this._packageList.remove(index);
        return obj;
    }

    public void setCmaps(Cmaps cmaps) {
        this._cmaps = cmaps;
    }

    public void setElementDimension(int elementDimension) {
        this._elementDimension = elementDimension;
        this._has_elementDimension = true;
    }

    public void setPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("setPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        this._packageList.set(index, vPackage);
    }

    public void setPackage(Package[] vPackageArray) {
        this._packageList.clear();
        for (int i = 0; i < vPackageArray.length; ++i) {
            this._packageList.add(vPackageArray[i]);
        }
    }

    public void setPackage(List<Package> vPackageList) {
        this._packageList.clear();
        this._packageList.addAll(vPackageList);
    }

    public void setPackageCollection(List<Package> _packageList) {
        this._packageList = _packageList;
    }

    public static MapsAdapterConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (MapsAdapterConfiguration)Unmarshaller.unmarshal(MapsAdapterConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

