/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.nfunk.jep.JEP;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdExpressionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionConfigWrapper
extends BaseThresholdDefConfigWrapper {
    private Expression m_expression;
    private Collection<String> m_datasources;

    public ExpressionConfigWrapper(Expression expression) throws ThresholdExpressionException {
        super((Basethresholddef)expression);
        this.m_expression = expression;
        this.m_datasources = new ArrayList<String>();
        JEP expressionParser = new JEP();
        expressionParser.setAllowUndeclared(true);
        expressionParser.addStandardFunctions();
        expressionParser.parseExpression(this.m_expression.getExpression());
        if (expressionParser.hasError()) {
            throw new ThresholdExpressionException("Could not parse threshold expression:" + expressionParser.getErrorInfo());
        }
        this.m_datasources.addAll(expressionParser.getSymbolTable().keySet());
    }

    @Override
    public String getDatasourceExpression() {
        return this.m_expression.getExpression();
    }

    @Override
    public Collection<String> getRequiredDatasources() {
        return this.m_datasources;
    }

    @Override
    public double evaluate(Map<String, Double> values) throws ThresholdExpressionException {
        JEP expressionParser = new JEP();
        expressionParser.setAllowUndeclared(true);
        expressionParser.addStandardFunctions();
        expressionParser.parseExpression(this.m_expression.getExpression());
        for (String valueName : values.keySet()) {
            expressionParser.addVariable(valueName, (Object)values.get(valueName));
        }
        double result = expressionParser.getValue();
        if (expressionParser.hasError()) {
            throw new ThresholdExpressionException("Error while evaluating expression " + this.m_expression.getExpression() + ": " + expressionParser.getErrorInfo());
        }
        return result;
    }
}

