/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller;

import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollContext;
import org.opennms.netmgt.utils.Updater;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPollContext
implements PollContext {
    private volatile EventIpcManager m_eventManager;
    private volatile String m_name;
    private volatile String m_localHostName;
    private SnmpInterfaceDao m_snmpInterfaceDao;
    private DataSource m_dataSource;
    private String m_serviceName = "SNMP";

    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventManager;
    }

    public void setEventManager(EventIpcManager eventManager) {
        this.m_eventManager = eventManager;
    }

    public void setLocalHostName(String localHostName) {
        this.m_localHostName = localHostName;
    }

    public String getLocalHostName() {
        return this.m_localHostName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public void sendEvent(Event event) {
        this.getEventManager().sendNow(event);
    }

    ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public Event createEvent(String uei, int nodeId, String address, Date date, OnmsSnmpInterface snmpinterface) {
        this.log().debug("createEvent: uei = " + uei + " nodeid = " + nodeId + " date = " + date);
        EventBuilder bldr = new EventBuilder(uei, this.getName(), date);
        bldr.setNodeid(nodeId);
        if (address != null) {
            bldr.setInterface(address);
        }
        bldr.setService(this.getServiceName());
        bldr.setHost(this.getLocalHostName());
        bldr.setField("ifIndex", snmpinterface.getIfIndex().toString());
        bldr.addParam("snmpifindex", snmpinterface.getIfIndex().toString());
        bldr.addParam("ipaddr", snmpinterface.getIpAddress());
        if (snmpinterface.getIfName() != null) {
            bldr.addParam("snmpifname", snmpinterface.getIfName());
        }
        if (snmpinterface.getIfDescr() != null) {
            bldr.addParam("snmpifdescr", snmpinterface.getIfDescr());
        }
        if (snmpinterface.getIfAlias() != null) {
            bldr.addParam("snmpifalias", snmpinterface.getIfAlias());
        }
        if (snmpinterface.getNetMask() != null) {
            bldr.addParam("mask", snmpinterface.getNetMask());
        }
        return bldr.getEvent();
    }

    @Override
    public List<OnmsSnmpInterface> get(int nodeId, String criteria) {
        OnmsCriteria onmsCriteria = new OnmsCriteria(OnmsSnmpInterface.class);
        onmsCriteria.add(Restrictions.sqlRestriction((String)(criteria + " and nodeid = " + nodeId)));
        return this.getSnmpInterfaceDao().findMatching(onmsCriteria);
    }

    @Override
    public void update(OnmsSnmpInterface snmpinterface) {
        OnmsSnmpInterface dbSnmpInterface = this.getSnmpInterfaceDao().findByNodeIdAndIfIndex(snmpinterface.getNode().getId(), snmpinterface.getIfIndex());
        if (dbSnmpInterface == null) {
            this.log().debug("updating SnmpInterface: no interface found on db for: " + snmpinterface.toString());
        } else {
            dbSnmpInterface.setIfOperStatus(snmpinterface.getIfOperStatus());
            dbSnmpInterface.setIfAdminStatus(snmpinterface.getIfAdminStatus());
            dbSnmpInterface.setLastSnmpPoll(snmpinterface.getLastSnmpPoll());
            this.log().debug("updating SnmpInterface: " + dbSnmpInterface.toString());
            this.getSnmpInterfaceDao().update((Object)dbSnmpInterface);
        }
    }

    @Override
    public void updatePollStatus(int nodeId, String criteria, String status) {
        String sql = "update snmpinterface set snmppoll = ? where nodeid = ? and " + criteria;
        Updater updater = new Updater(this.m_dataSource, sql);
        updater.execute(status, new Integer(nodeId));
    }

    @Override
    public void updatePollStatus(int nodeId, String status) {
        String sql = "update snmpinterface set snmppoll = ? where nodeid = ? ";
        Updater updater = new Updater(this.m_dataSource, sql);
        updater.execute(status, new Integer(nodeId));
    }

    @Override
    public void updatePollStatus(String status) {
        String sql = "update snmpinterface set snmppoll = ? ";
        Updater updater = new Updater(this.m_dataSource, "update snmpinterface set snmppoll = ? ");
        updater.execute(status);
    }
}

