/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.datablock;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opennms.netmgt.rtc.RTCConstants;
import org.opennms.netmgt.rtc.datablock.RTCNodeKey;
import org.opennms.netmgt.rtc.datablock.RTCNodeSvcTime;
import org.opennms.netmgt.rtc.datablock.RTCNodeSvcTimesList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTCNode {
    private long m_nodeID;
    private String m_ip;
    private String m_svcName;
    private RTCNodeSvcTimesList m_svcTimesList;
    private List<String> m_categories;

    public RTCNode() {
        this(-1L, null, null);
    }

    public RTCNode(RTCNodeKey key) {
        this(key.getNodeID(), key.getIP(), key.getSvcName());
    }

    public RTCNode(long nodeid, String ip, String svcName) {
        this.m_nodeID = nodeid;
        this.m_ip = ip;
        this.m_svcName = svcName;
        this.m_svcTimesList = new RTCNodeSvcTimesList();
        this.m_categories = new ArrayList<String>();
    }

    public void setNodeID(long id) {
        this.m_nodeID = id;
    }

    public void setSvcName(String svcName) {
        this.m_svcName = svcName;
    }

    public void setIP(String ipStr) {
        this.m_ip = ipStr;
    }

    public void addSvcTime(long losttime, long regainedtime) {
        this.m_svcTimesList.addSvcTime(losttime, regainedtime);
    }

    public void addCategory(String catLabel) {
        int index = this.m_categories.indexOf(catLabel);
        if (index == -1) {
            this.m_categories.add(catLabel);
        }
    }

    public void removeCategory(String catLabel) {
        int index = this.m_categories.indexOf(catLabel);
        if (index != -1) {
            this.m_categories.remove(catLabel);
        }
    }

    public synchronized void nodeLostService(long t) {
        RTCNodeSvcTime stime;
        int listsize = this.m_svcTimesList.size();
        if (listsize > 0 && (stime = (RTCNodeSvcTime)this.m_svcTimesList.get(listsize - 1)).getRegainedTime() == -1L) {
            return;
        }
        RTCNodeSvcTime newStime = new RTCNodeSvcTime(t);
        this.m_svcTimesList.add(newStime);
    }

    public synchronized void nodeRegainedService(long t) {
        int listsize = this.m_svcTimesList.size();
        if (listsize > 0) {
            RTCNodeSvcTime stime = (RTCNodeSvcTime)this.m_svcTimesList.get(listsize - 1);
            if (stime.getRegainedTime() != -1L) {
                return;
            }
            stime.setRegainedTime(t);
        }
    }

    public long getNodeID() {
        return this.m_nodeID;
    }

    public String getSvcName() {
        return this.m_svcName;
    }

    public String getIP() {
        return this.m_ip;
    }

    public List<RTCNodeSvcTime> getServiceTimes() {
        return this.m_svcTimesList;
    }

    public boolean belongsTo(String catLabel) {
        return this.m_categories.contains(catLabel);
    }

    public List<String> getCategories() {
        return this.m_categories;
    }

    public long getDownTime(String cat, long curTime, long rollingWindow) {
        if (!this.m_categories.contains(cat)) {
            return (long)RTCConstants.NODE_NOT_IN_CATEGORY;
        }
        return this.m_svcTimesList.getDownTime(curTime, rollingWindow);
    }

    public double getValue(String cat, long curTime, long rollingWindow) {
        double value = 0.0;
        long outageTime = this.getDownTime(cat, curTime, rollingWindow);
        if (outageTime < 0L) {
            return outageTime;
        }
        double dOut = (double)outageTime * 1.0;
        double dRoll = (double)rollingWindow * 1.0;
        value = 100.0 * (1.0 - dOut / dRoll);
        return value;
    }

    public boolean isServiceCurrentlyDown() {
        int size = this.m_svcTimesList.size();
        if (size == 0) {
            return false;
        }
        RTCNodeSvcTime svctime = (RTCNodeSvcTime)this.m_svcTimesList.get(size - 1);
        if (svctime.getRegainedTime() != -1L) {
            return false;
        }
        long svclosttime = svctime.getLostTime();
        return svclosttime != -1L;
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 7).append(this.m_nodeID).append((Object)this.m_ip).append((Object)this.m_svcName).append(this.m_categories).append((Object)this.m_svcTimesList).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RTCNode)) {
            return false;
        }
        RTCNode obj = (RTCNode)o;
        return this.m_nodeID == obj.getNodeID() && this.m_ip.equals(obj.getIP()) && this.m_svcName.equals(obj.getSvcName());
    }

    public String toString() {
        String s = "RTCNode\n[\n\tnodeID       = " + this.m_nodeID + "\n\t" + "IP           = " + this.m_ip + "\n\t" + "Service      = " + this.m_svcName + "\n\t" + "\n]\n";
        return s;
    }
}

