/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.monitors.HttpMonitor;
import org.opennms.netmgt.utils.RelaxedX509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public final class HttpsMonitor
extends HttpMonitor {
    private static final int[] DEFAULT_PORTS = new int[]{443};

    @Override
    protected int[] determinePorts(Map<String, Object> parameters) {
        return ParameterMap.getKeyedIntegerArray(parameters, (String)"port", (int[])DEFAULT_PORTS);
    }

    @Override
    protected Socket wrapSocket(Socket socket) throws IOException {
        TrustManager[] tm = new TrustManager[]{new RelaxedX509TrustManager()};
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, tm, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            this.log().error("wrapSocket: Error wrapping socket, throwing runtime exception..." + e);
            throw new IllegalStateException("No such algorith in SSLSocketFactory: " + e);
        }
        catch (KeyManagementException e) {
            this.log().error("wrapSocket: Error wrapping socket, throwing runtime exception..." + e);
            throw new IllegalStateException("Key management exception in SSLSocketFactory: " + e);
        }
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        InetAddress inetAddress = socket.getInetAddress();
        String hostAddress = inetAddress.getHostAddress();
        int port = socket.getPort();
        Socket wrappedSocket = socketFactory.createSocket(socket, hostAddress, port, true);
        return wrappedSocket;
    }
}

