/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpUtils;

public final class QBridgeDot1dTpFdbTableEntry
extends SnmpTableEntry {
    public static final String FDB_ADDRESS = "dot1dTpFdbAddress";
    public static final String FDB_ADDRESS_OID = ".1.3.6.1.2.1.17.7.1.2.2.1.1";
    public static final String FDB_PORT = "dot1dTpFdbPort";
    public static final String FDB_STATUS = "dot1dTpFdbStatus";
    private boolean hasFdbAddressFromBase = false;
    public static NamedSnmpVar[] ms_elemList = null;
    public static final String TABLE_OID = ".1.3.6.1.2.1.17.7.1.2.2";

    public QBridgeDot1dTpFdbTableEntry() {
        super(ms_elemList);
    }

    public void storeResult(SnmpResult res) {
        super.storeResult(res);
        if (!SnmpObjId.get((String)FDB_ADDRESS_OID).isPrefixOf(res.getBase()) && !this.hasFdbAddressFromBase) {
            int[] identifiers = res.getInstance().getIds();
            StringBuilder sb = new StringBuilder();
            for (int i = identifiers.length - 6; i < identifiers.length; ++i) {
                if (identifiers[i] >= 16) {
                    sb.append(Integer.toHexString(identifiers[i]));
                    continue;
                }
                sb.append("0").append(Integer.toHexString(identifiers[i]));
            }
            super.storeResult(new SnmpResult(SnmpObjId.get((String)FDB_ADDRESS_OID), res.getInstance(), SnmpUtils.getValueFactory().getOctetString(sb.toString().getBytes())));
            this.hasFdbAddressFromBase = true;
        }
    }

    public String getQBridgeDot1dTpFdbAddress() {
        if (this.hasFdbAddressFromBase) {
            return this.getDisplayString(FDB_ADDRESS);
        }
        return this.getHexString(FDB_ADDRESS);
    }

    public int getQBridgeDot1dTpFdbPort() {
        Integer val = this.getInt32(FDB_PORT);
        if (val == null) {
            return -1;
        }
        return val;
    }

    public int getQBridgeDot1dTpFdbStatus() {
        Integer val = this.getInt32(FDB_STATUS);
        if (val == null) {
            return -1;
        }
        return val;
    }

    static {
        ms_elemList = new NamedSnmpVar[3];
        int ndx = 0;
        QBridgeDot1dTpFdbTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", FDB_ADDRESS, FDB_ADDRESS_OID, 1);
        QBridgeDot1dTpFdbTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", FDB_PORT, ".1.3.6.1.2.1.17.7.1.2.2.1.2", 2);
        QBridgeDot1dTpFdbTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", FDB_STATUS, ".1.3.6.1.2.1.17.7.1.2.2.1.3", 3);
    }
}

