/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.eventd.EventdServiceManager;
import org.opennms.netmgt.model.OnmsServiceType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional(readOnly=true)
public class DaoEventdServiceManager
implements InitializingBean,
EventdServiceManager {
    private ServiceTypeDao m_serviceTypeDao;
    private Map<String, Integer> m_serviceMap = new HashMap<String, Integer>();

    public synchronized int getServiceId(String serviceName) throws DataAccessException {
        Assert.notNull((Object)serviceName, (String)"The serviceName argument must not be null");
        if (this.m_serviceMap.containsKey(serviceName)) {
            return this.m_serviceMap.get(serviceName);
        }
        this.log().debug("Could not find entry for '" + serviceName + "' in service name cache.  Looking up in database.");
        OnmsServiceType serviceType = this.m_serviceTypeDao.findByName(serviceName);
        if (serviceType == null) {
            this.log().debug("Did not find entry for '" + serviceName + "' in database.");
            return -1;
        }
        this.log().debug("Found entry for '" + serviceName + "' (ID " + serviceType.getId() + " in database.  Adding to service name cache.");
        this.m_serviceMap.put(serviceType.getName(), serviceType.getId());
        return serviceType.getId();
    }

    public synchronized void dataSourceSync() {
        this.m_serviceMap.clear();
        for (OnmsServiceType serviceType : this.m_serviceTypeDao.findAll()) {
            this.m_serviceMap.put(serviceType.getName(), serviceType.getId());
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_serviceTypeDao != null ? 1 : 0) != 0, (String)"property serviceTypeDao must be set");
    }

    public ServiceTypeDao getServiceTypeDao() {
        return this.m_serviceTypeDao;
    }

    public void setServiceTypeDao(ServiceTypeDao serviceTypeDao) {
        this.m_serviceTypeDao = serviceTypeDao;
    }
}

