/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.vulnscand.Excludes;
import org.opennms.netmgt.config.vulnscand.Range;
import org.opennms.netmgt.config.vulnscand.ScanLevel;
import org.opennms.netmgt.config.vulnscand.VulnscandConfiguration;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.protocols.ip.IPv4Address;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VulnscandConfigFactory {
    private static boolean m_loaded = false;
    private static VulnscandConfigFactory m_singleton = null;
    private static VulnscandConfiguration m_config;
    private static String[] m_pluginLists;
    private static boolean[] m_safeChecks;
    private static Set<Serializable> m_excludes;
    private static RE m_space;
    private static final String RETRIEVE_IPADDR_SQL = "SELECT ipaddr FROM ipinterface WHERE ipaddr=? AND ismanaged!='D'";
    private static final String RETRIEVE_IPADDR_NODEID_SQL = "SELECT nodeid FROM ipinterface WHERE ipaddr=? AND ismanaged!='D'";

    private VulnscandConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        m_config = (VulnscandConfiguration)CastorUtils.unmarshal(VulnscandConfiguration.class, (Resource)new FileSystemResource(configFile));
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.VULNSCAND_CONFIG_FILE_NAME);
        ThreadCategory.getInstance(VulnscandConfigFactory.class).debug("init: config file path: " + cfgFile.getPath());
        m_singleton = new VulnscandConfigFactory(cfgFile.getPath());
        try {
            m_space = new RE("[:space:]+");
        }
        catch (RESyntaxException ex) {
            ThreadCategory.getInstance(VulnscandConfigFactory.class).error("UNEXPECTED CONDITION: Regex in config factory is incorrect. Check the code.", (Throwable)ex);
        }
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        m_pluginLists = null;
        m_safeChecks = null;
        m_excludes = null;
        VulnscandConfigFactory.init();
    }

    public static synchronized void saveCurrent() throws Exception {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)m_config, (Writer)stringWriter);
        if (stringWriter.toString() != null) {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.VULNSCAND_CONFIG_FILE_NAME)), "UTF-8");
            fileWriter.write(stringWriter.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        VulnscandConfigFactory.reload();
    }

    public static synchronized VulnscandConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static VulnscandConfiguration getConfiguration() {
        return m_config;
    }

    public static long toLong(InetAddress addr) {
        byte[] baddr = addr.getAddress();
        return ((long)baddr[0] & 0xFFL) << 24 | ((long)baddr[1] & 0xFFL) << 16 | ((long)baddr[2] & 0xFFL) << 8 | (long)baddr[3] & 0xFFL;
    }

    public static InetAddress toInetAddress(long address) throws UnknownHostException {
        StringBuffer buf = new StringBuffer();
        buf.append((int)(address >>> 24 & 0xFFL)).append('.');
        buf.append((int)(address >>> 16 & 0xFFL)).append('.');
        buf.append((int)(address >>> 8 & 0xFFL)).append('.');
        buf.append((int)(address & 0xFFL));
        return InetAddress.getByName(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInterfaceInDB(Connection dbConn, InetAddress ifAddress) throws SQLException {
        ThreadCategory log = ThreadCategory.getInstance(VulnscandConfigFactory.class);
        boolean result = false;
        log.debug("isInterfaceInDB: attempting to lookup interface " + ifAddress.getHostAddress() + " in the database.");
        DBUtils d = new DBUtils(VulnscandConfigFactory.class);
        try {
            PreparedStatement s = dbConn.prepareStatement(RETRIEVE_IPADDR_SQL);
            d.watch((Object)s);
            s.setString(1, ifAddress.getHostAddress());
            ResultSet rs = s.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                result = true;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInterfaceDbNodeId(Connection dbConn, InetAddress ifAddress) throws SQLException {
        ThreadCategory log = ThreadCategory.getInstance(VulnscandConfigFactory.class);
        log.debug("getInterfaceDbNodeId: attempting to lookup interface " + ifAddress.getHostAddress() + " in the database.");
        int nodeid = -1;
        DBUtils d = new DBUtils(VulnscandConfigFactory.class);
        try {
            PreparedStatement s = dbConn.prepareStatement(RETRIEVE_IPADDR_NODEID_SQL);
            d.watch((Object)s);
            s.setString(1, ifAddress.getHostAddress());
            ResultSet rs = s.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                nodeid = rs.getInt(1);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        return nodeid;
    }

    private static ScanLevel getScanLevel(int level) {
        Enumeration scanLevels = m_config.enumerateScanLevel();
        while (scanLevels.hasMoreElements()) {
            ScanLevel scanLevel = (ScanLevel)scanLevels.nextElement();
            if (level != scanLevel.getLevel()) continue;
            return scanLevel;
        }
        throw new ArrayIndexOutOfBoundsException("No scan level with that index could be located in the configuration file, index = " + level);
    }

    public void addSpecific(int level, InetAddress specific) {
        this.addSpecific(VulnscandConfigFactory.getScanLevel(level), specific);
    }

    public void addSpecific(ScanLevel level, InetAddress specific) {
        level.addSpecific(specific.getHostAddress());
    }

    public void addRange(int level, InetAddress begin, InetAddress end) {
        this.addRange(VulnscandConfigFactory.getScanLevel(level), begin, end);
    }

    public void addRange(ScanLevel level, InetAddress begin, InetAddress end) {
        Range addMe = new Range();
        addMe.setBegin(begin.getHostAddress());
        addMe.setEnd(end.getHostAddress());
        level.addRange(addMe);
    }

    public void removeSpecific(int level, InetAddress specific) {
        this.removeSpecific(VulnscandConfigFactory.getScanLevel(level), specific);
    }

    public void removeSpecific(ScanLevel level, InetAddress specific) {
        level.removeSpecific(specific.getHostAddress());
    }

    public void removeRange(int level, InetAddress begin, InetAddress end) {
        this.removeRange(VulnscandConfigFactory.getScanLevel(level), begin, end);
    }

    public void removeRange(ScanLevel level, InetAddress begin, InetAddress end) {
        Range removeMe = new Range();
        removeMe.setBegin(begin.getHostAddress());
        removeMe.setEnd(end.getHostAddress());
        level.removeRange(removeMe);
    }

    public Set<InetAddress> getAllIpAddresses(int level) {
        return this.getAllIpAddresses(VulnscandConfigFactory.getScanLevel(level));
    }

    public Set<InetAddress> getAllIpAddresses(ScanLevel level) {
        TreeSet<InetAddress> retval = new TreeSet<InetAddress>();
        Enumeration e = level.enumerateRange();
        while (e.hasMoreElements()) {
            Range ir = (Range)e.nextElement();
            try {
                for (long i = Long.parseLong(ir.getBegin()); i <= Long.parseLong(ir.getEnd()); ++i) {
                    retval.add(VulnscandConfigFactory.toInetAddress(i));
                }
            }
            catch (NumberFormatException wanker) {
                ThreadCategory.getInstance(this.getClass()).warn("Failed to convert address range (" + ir.getBegin() + ", " + ir.getEnd() + ")", (Throwable)wanker);
            }
            catch (UnknownHostException uhE) {
                ThreadCategory.getInstance(this.getClass()).warn("Failed to convert address range (" + ir.getBegin() + ", " + ir.getEnd() + ")", (Throwable)uhE);
            }
        }
        e = level.enumerateSpecific();
        while (e.hasMoreElements()) {
            String current = (String)e.nextElement();
            try {
                retval.add(InetAddress.getByName(current));
            }
            catch (UnknownHostException uhE) {
                ThreadCategory.getInstance().warn("Failed to convert address: " + current, (Throwable)uhE);
            }
        }
        return retval;
    }

    public Set<Serializable> getAllExcludes() {
        ThreadCategory log = ThreadCategory.getInstance(VulnscandConfigFactory.class);
        if (m_excludes == null) {
            m_excludes = new TreeSet<Serializable>();
            Excludes excludes = m_config.getExcludes();
            if (excludes != null) {
                Enumeration e;
                if (excludes.getRangeCount() > 0) {
                    e = excludes.enumerateRange();
                    while (e.hasMoreElements()) {
                        Range ir = (Range)e.nextElement();
                        try {
                            for (long i = Long.parseLong(ir.getBegin()); i <= Long.parseLong(ir.getEnd()); ++i) {
                                m_excludes.add(VulnscandConfigFactory.toInetAddress(i));
                            }
                        }
                        catch (UnknownHostException uhE) {
                            ThreadCategory.getInstance(this.getClass()).warn("Failed to convert address range (" + ir.getBegin() + ", " + ir.getEnd() + ")", (Throwable)uhE);
                        }
                    }
                }
                if (excludes.getSpecificCount() > 0) {
                    e = excludes.enumerateSpecific();
                    while (e.hasMoreElements()) {
                        String current = (String)e.nextElement();
                        log.debug("excludes: Specific  " + current + " Converted:" + new IPv4Address(current).getAddress());
                        m_excludes.add((Serializable)((Object)current));
                    }
                }
            }
        }
        return m_excludes;
    }

    public void removeExcludeRange(InetAddress begin, InetAddress end) {
        Range removeMe = new Range();
        removeMe.setBegin(begin.getHostAddress());
        removeMe.setEnd(end.getHostAddress());
        m_config.getExcludes().removeRange(removeMe);
    }

    public void removeExcludeSpecific(InetAddress specific) {
        m_config.getExcludes().removeSpecific(specific.getHostAddress());
    }

    public long getRescanFrequency() {
        long frequency = -1L;
        if (m_config.hasRescanFrequency()) {
            frequency = m_config.getRescanFrequency();
        } else {
            ThreadCategory.getInstance(VulnscandConfigFactory.class).warn("Vulnscand configuration file is missing rescan interval, defaulting to 24 hour interval.");
            frequency = 86400000L;
        }
        return frequency;
    }

    public long getInitialSleepTime() {
        long sleep = -1L;
        if (m_config.hasInitialSleepTime()) {
            sleep = m_config.getInitialSleepTime();
        } else {
            ThreadCategory.getInstance(VulnscandConfigFactory.class).warn("Vulnscand configuration file is missing initial pause time, defaulting to 5 minutes.");
            sleep = 300000L;
        }
        return sleep;
    }

    public InetAddress getServerAddress() {
        try {
            return InetAddress.getByName(m_config.getServerAddress());
        }
        catch (UnknownHostException ex) {
            ThreadCategory.getInstance(VulnscandConfigFactory.class).error("Invalid server in config file", (Throwable)ex);
            return null;
        }
    }

    public String[] getPluginLists() {
        if (m_pluginLists == null) {
            m_pluginLists = new String[5];
            VulnscandConfigFactory.m_pluginLists[0] = "";
            try {
                Enumeration scanLevels = m_config.enumerateScanLevel();
                while (scanLevels.hasMoreElements()) {
                    ScanLevel scanLevel = (ScanLevel)scanLevels.nextElement();
                    String levelPluginList = scanLevel.getPluginList();
                    levelPluginList = levelPluginList.replace('\n', ' ');
                    levelPluginList = levelPluginList.replace('\t', ' ');
                    VulnscandConfigFactory.m_pluginLists[scanLevel.getLevel()] = levelPluginList = m_space.subst(levelPluginList, "");
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ThreadCategory.getInstance(this.getClass()).error("Error while loading plugin lists from config file", (Throwable)ex);
            }
        }
        return m_pluginLists;
    }

    public boolean[] getSafeChecks() {
        if (m_safeChecks == null) {
            m_safeChecks = new boolean[5];
            VulnscandConfigFactory.m_safeChecks[0] = true;
            try {
                Enumeration scanLevels = m_config.enumerateScanLevel();
                while (scanLevels.hasMoreElements()) {
                    ScanLevel scanLevel = (ScanLevel)scanLevels.nextElement();
                    VulnscandConfigFactory.m_safeChecks[scanLevel.getLevel()] = scanLevel.getSafeChecks();
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ThreadCategory.getInstance(this.getClass()).error("Error while loading safe checks settings from config file", (Throwable)ex);
            }
        }
        return m_safeChecks;
    }

    public int getServerPort() {
        return m_config.getServerPort();
    }

    public String getServerUsername() {
        return m_config.getServerUsername();
    }

    public String getServerPassword() {
        return m_config.getServerPassword();
    }

    public boolean getStatus() {
        return m_config.getStatus();
    }

    public boolean getManagedInterfacesStatus() {
        return m_config.getManagedInterfaces().getStatus();
    }

    public int getManagedInterfacesScanLevel() {
        return m_config.getManagedInterfaces().getScanLevel();
    }

    public int getMaxSuspectThreadPoolSize() {
        return m_config.getMaxSuspectThreadPoolSize();
    }

    public int getMaxRescanThreadPoolSize() {
        return m_config.getMaxRescanThreadPoolSize();
    }

    static {
        m_pluginLists = null;
        m_safeChecks = null;
        m_excludes = null;
        m_space = null;
    }
}

