/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.config.trapd.Snmpv3User;
import org.opennms.netmgt.config.trapd.TrapdConfiguration;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TrapdConfigFactory
implements TrapdConfig {
    private static TrapdConfig m_singleton = null;
    private TrapdConfiguration m_config;
    private static boolean m_loaded = false;

    private TrapdConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        this.m_config = (TrapdConfiguration)CastorUtils.unmarshal(TrapdConfiguration.class, (Resource)new FileSystemResource(configFile));
    }

    public TrapdConfigFactory(InputStream stream) throws MarshalException, ValidationException {
        this.m_config = (TrapdConfiguration)CastorUtils.unmarshal(TrapdConfiguration.class, (InputStream)stream);
    }

    @Deprecated
    public TrapdConfigFactory(Reader rdr) throws MarshalException, ValidationException {
        this.m_config = (TrapdConfiguration)CastorUtils.unmarshal(TrapdConfiguration.class, (Reader)rdr);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.TRAPD_CONFIG_FILE_NAME);
        m_singleton = new TrapdConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        TrapdConfigFactory.init();
    }

    public static synchronized TrapdConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(TrapdConfig config) {
        m_singleton = config;
        m_loaded = true;
    }

    @Override
    public synchronized int getSnmpTrapPort() {
        return this.m_config.getSnmpTrapPort();
    }

    @Override
    public synchronized boolean getNewSuspectOnTrap() {
        return this.m_config.getNewSuspectOnTrap();
    }

    @Override
    public synchronized List<SnmpV3User> getSnmpV3Users() {
        ArrayList<SnmpV3User> snmpUsers = new ArrayList<SnmpV3User>();
        for (Snmpv3User user : this.m_config.getSnmpv3UserCollection()) {
            snmpUsers.add(new SnmpV3User(user.getEngineId(), user.getSecurityName(), user.getAuthProtocol(), user.getAuthPassphrase(), user.getPrivacyProtocol(), user.getPrivacyPassphrase()));
        }
        return snmpUsers;
    }
}

