/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.ThreshdConfigManager;

public final class ThreshdConfigFactory
extends ThreshdConfigManager {
    private static ThreshdConfigFactory m_singleton = null;
    private static boolean m_loaded = false;

    @Deprecated
    public ThreshdConfigFactory(Reader rdr, String localServer, boolean verifyServer) throws IOException, MarshalException, ValidationException {
        super(rdr, localServer, verifyServer);
    }

    public ThreshdConfigFactory(InputStream stream, String localServer, boolean verifyServer) throws IOException, MarshalException, ValidationException {
        super(stream, localServer, verifyServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        OpennmsServerConfigFactory.init();
        boolean verifyServer = OpennmsServerConfigFactory.getInstance().verifyServer();
        String localServer = OpennmsServerConfigFactory.getInstance().getServerName();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHD_CONFIG_FILE_NAME);
        ThreadCategory.getInstance(ThreshdConfigFactory.class).debug("init: config file path: " + cfgFile.getPath());
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(cfgFile);
            m_singleton = new ThreshdConfigFactory(stream, localServer, verifyServer);
            m_loaded = true;
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        ThreshdConfigFactory.init();
    }

    public void reloadXML() throws IOException, MarshalException, ValidationException {
        ThreshdConfigFactory.reload();
    }

    protected void saveXML(String xmlString) throws IOException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHD_CONFIG_FILE_NAME);
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
        fileWriter.write(xmlString);
        ((Writer)fileWriter).flush();
        ((Writer)fileWriter).close();
    }

    public static synchronized ThreshdConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static void setInstance(ThreshdConfigFactory configFactory) {
        m_loaded = true;
        m_singleton = configFactory;
    }
}

