/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.netmgt.config.BasicScheduleUtils;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.common.BasicSchedule;
import org.opennms.netmgt.config.common.Time;
import org.opennms.netmgt.config.poller.Interface;
import org.opennms.netmgt.config.poller.Node;
import org.opennms.netmgt.config.poller.Outage;
import org.opennms.netmgt.config.poller.Outages;
import org.opennms.netmgt.dao.castor.AbstractCastorConfigDao;
import org.springframework.dao.DataAccessException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PollOutagesConfigManager
extends AbstractCastorConfigDao<Outages, Outages>
implements PollOutagesConfig {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();

    public PollOutagesConfigManager() {
        super(Outages.class, "poll outage configuration");
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    protected String createLoadedLogMessage(Outages config, long diffTime) {
        return "Loaded " + this.getDescription() + " with " + config.getOutageCount() + " outages in " + diffTime + "ms";
    }

    public void afterPropertiesSet() throws DataAccessException {
        Assert.state((this.getConfigResource() != null ? 1 : 0) != 0, (String)"property configResource must be set and be non-null");
        super.afterPropertiesSet();
    }

    public Outages translateConfig(Outages outages) {
        return outages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Outages getConfig() {
        this.getReadLock().lock();
        try {
            Outages outages = (Outages)this.getContainer().getObject();
            return outages;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outage[] getOutages() {
        this.getReadLock().lock();
        try {
            Outage[] outageArray = this.getConfig().getOutage();
            return outageArray;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outage getOutage(String name) {
        this.getReadLock().lock();
        try {
            for (Outage out : this.getConfig().getOutageCollection()) {
                if (!out.getName().equals(name)) continue;
                Outage outage = out;
                return outage;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    public String getOutageType(String name) {
        Outage out = this.getOutage(name);
        if (out == null) {
            return null;
        }
        return out.getType();
    }

    public Time[] getOutageTimes(String name) {
        Outage out = this.getOutage(name);
        if (out == null) {
            return null;
        }
        return out.getTime();
    }

    public Interface[] getInterfaces(String name) {
        Outage out = this.getOutage(name);
        if (out == null) {
            return null;
        }
        return out.getInterface();
    }

    @Override
    public boolean isInterfaceInOutage(String linterface, String outName) {
        Outage out = this.getOutage(outName);
        if (out == null) {
            return false;
        }
        return this.isInterfaceInOutage(linterface, out);
    }

    public boolean isInterfaceInOutage(String linterface, Outage out) {
        if (out == null) {
            return false;
        }
        for (Interface ointerface : out.getInterfaceCollection()) {
            if (!ointerface.getAddress().equals("match-any") && !ointerface.getAddress().equals(linterface)) continue;
            return true;
        }
        return false;
    }

    public boolean isTimeInOutage(Calendar cal, String outName) {
        Outage out = this.getOutage(outName);
        if (out == null) {
            return false;
        }
        return this.isTimeInOutage(cal, out);
    }

    @Override
    public boolean isTimeInOutage(long time, String outName) {
        Outage out = this.getOutage(outName);
        if (out == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return this.isTimeInOutage(cal, out);
    }

    public boolean isTimeInOutage(Calendar cal, Outage outage) {
        return BasicScheduleUtils.isTimeInSchedule(cal, (BasicSchedule)outage);
    }

    @Override
    public boolean isCurTimeInOutage(String outName) {
        return this.isTimeInOutage((Calendar)new GregorianCalendar(), outName);
    }

    public boolean isCurTimeInOutage(Outage out) {
        return this.isTimeInOutage((Calendar)new GregorianCalendar(), out);
    }

    public void addOutage(Outage newOutage) {
        this.getConfig().addOutage(newOutage);
    }

    public void removeOutage(String outageName) {
        this.getConfig().removeOutage(this.getOutage(outageName));
    }

    public void removeOutage(Outage outageToRemove) {
        this.getConfig().removeOutage(outageToRemove);
    }

    public void replaceOutage(Outage oldOutage, Outage newOutage) {
        int count = this.getConfig().getOutageCount();
        for (int i = 0; i < count; ++i) {
            if (!this.getConfig().getOutage(i).equals((Object)oldOutage)) continue;
            this.getConfig().setOutage(i, newOutage);
            return;
        }
    }

    public Node[] getNodeIds(String name) {
        Outage out = this.getOutage(name);
        if (out == null) {
            return null;
        }
        return out.getNode();
    }

    @Override
    public boolean isNodeIdInOutage(long lnodeid, String outName) {
        Outage out = this.getOutage(outName);
        if (out == null) {
            return false;
        }
        return this.isNodeIdInOutage(lnodeid, out);
    }

    public Calendar getEndOfOutage(String outName) {
        Outage out = this.getOutage(outName);
        if (out == null) {
            return null;
        }
        return PollOutagesConfigManager.getEndOfOutage(out);
    }

    public static Calendar getEndOfOutage(Outage out) {
        return BasicScheduleUtils.getEndOfSchedule((BasicSchedule)out);
    }

    public boolean isNodeIdInOutage(long lnodeid, Outage out) {
        if (out == null) {
            return false;
        }
        for (Node onode : out.getNodeCollection()) {
            if ((long)onode.getId() != lnodeid) continue;
            return true;
        }
        return false;
    }
}

