/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.IpListFromUrl;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.linkd.ExcludeRange;
import org.opennms.netmgt.config.linkd.Filter;
import org.opennms.netmgt.config.linkd.IncludeRange;
import org.opennms.netmgt.config.linkd.Iproutes;
import org.opennms.netmgt.config.linkd.LinkdConfiguration;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.config.linkd.Vendor;
import org.opennms.netmgt.config.linkd.Vlans;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.protocols.snmp.SnmpObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LinkdConfigManager
implements LinkdConfig {
    private static final String DEFAULT_IP_ROUTE_CLASS_NAME = "org.opennms.netmgt.linkd.snmp.IpRouteTable";
    protected static LinkdConfiguration m_config;
    private static Map<String, List<String>> m_urlIPMap;
    private static Map<Package, List<String>> m_pkgIpMap;
    private static Map<String, String> m_oidMask2VlanclassName;
    private static Map<String, String> m_oidMask2IpRouteclassName;

    @Deprecated
    public LinkdConfigManager(Reader reader) throws MarshalException, ValidationException, IOException {
        this.reloadXML(reader);
    }

    public LinkdConfigManager(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.reloadXML(stream);
    }

    @Override
    public abstract void update() throws IOException, MarshalException, ValidationException;

    protected abstract void saveXml(String var1) throws IOException;

    @Override
    public synchronized Package getPackage(String name) {
        for (Package thisPackage : m_config.getPackageCollection()) {
            String n = thisPackage.getName();
            if (n == null || !n.equals(name)) continue;
            return thisPackage;
        }
        return null;
    }

    private void createUrlIpMap() {
        for (Package pkg : m_config.getPackageCollection()) {
            if (pkg == null) continue;
            for (String urlname : pkg.getIncludeUrlCollection()) {
                List iplist = IpListFromUrl.parse((String)urlname);
                if (iplist.size() <= 0) continue;
                m_urlIPMap.put(urlname, iplist);
            }
        }
    }

    @Override
    public void createPackageIpListMap() {
        for (Package pkg : m_config.getPackageCollection()) {
            try {
                List<String> ipList = this.getIpList(pkg);
                LogUtils.tracef((Object)this, (String)"createPackageIpMap: package %s: ipList size = %d", (Object[])new Object[]{pkg.getName(), ipList.size()});
                if (ipList == null || ipList.size() <= 0) continue;
                m_pkgIpMap.put(pkg, ipList);
            }
            catch (Throwable t) {
                LogUtils.errorf((Object)this, (Throwable)t, (String)"createPackageIpMap: failed to map package: %s to an IP list", (Object[])new Object[]{pkg.getName()});
            }
        }
    }

    @Override
    public List<String> getIpList(Package pkg) {
        if (pkg == null) {
            return null;
        }
        Filter filter = pkg.getFilter();
        if (filter == null) {
            return null;
        }
        StringBuffer filterRules = new StringBuffer(filter.getContent());
        LogUtils.debugf((Object)this, (String)"createPackageIpMap: package is %s. filter rules are: %s", (Object[])new Object[]{pkg.getName(), filterRules.toString()});
        return FilterDaoFactory.getInstance().getIPList(filterRules.toString());
    }

    @Override
    public boolean useIpRouteDiscovery() {
        if (m_config.hasUseIpRouteDiscovery()) {
            return m_config.getUseIpRouteDiscovery();
        }
        return true;
    }

    @Override
    public boolean saveRouteTable() {
        if (m_config.hasSaveRouteTable()) {
            return m_config.getSaveRouteTable();
        }
        return true;
    }

    @Override
    public boolean useCdpDiscovery() {
        if (m_config.hasUseCdpDiscovery()) {
            return m_config.getUseCdpDiscovery();
        }
        return true;
    }

    @Override
    public boolean useBridgeDiscovery() {
        if (m_config.hasUseBridgeDiscovery()) {
            return m_config.getUseBridgeDiscovery();
        }
        return true;
    }

    @Override
    public boolean saveStpNodeTable() {
        if (m_config.hasSaveStpNodeTable()) {
            return m_config.getSaveStpNodeTable();
        }
        return true;
    }

    @Override
    public boolean enableDiscoveryDownload() {
        if (m_config.hasEnableDiscoveryDownload()) {
            return m_config.getEnableDiscoveryDownload();
        }
        return false;
    }

    @Override
    public boolean saveStpInterfaceTable() {
        if (m_config.hasSaveStpInterfaceTable()) {
            return m_config.getSaveStpInterfaceTable();
        }
        return true;
    }

    @Override
    public long getInitialSleepTime() {
        if (m_config.hasInitial_sleep_time()) {
            return m_config.getInitial_sleep_time();
        }
        return 1800000L;
    }

    @Override
    public long getSnmpPollInterval() {
        if (m_config.hasSnmp_poll_interval()) {
            return m_config.getSnmp_poll_interval();
        }
        return 900000L;
    }

    @Override
    public long getDiscoveryLinkInterval() {
        if (m_config.hasSnmp_poll_interval()) {
            return m_config.getDiscovery_link_interval();
        }
        return 3600000L;
    }

    @Override
    public int getThreads() {
        if (m_config.hasThreads()) {
            return m_config.getThreads();
        }
        return 5;
    }

    @Override
    public synchronized LinkdConfiguration getConfiguration() {
        return m_config;
    }

    @Override
    public boolean autoDiscovery() {
        if (m_config.hasAutoDiscovery()) {
            return m_config.getAutoDiscovery();
        }
        return false;
    }

    @Override
    public boolean enableVlanDiscovery() {
        if (m_config.hasEnableVlanDiscovery()) {
            return m_config.getEnableVlanDiscovery();
        }
        return true;
    }

    private void initializeIpRouteClassNames() throws IOException, MarshalException, ValidationException {
        Iproutes iproutes = m_config.getIproutes();
        if (iproutes == null) {
            LogUtils.infof((Object)this, (String)"no iproutes found in config", (Object[])new Object[0]);
            return;
        }
        for (Vendor vendor : iproutes.getVendorCollection()) {
            SnmpObjectId oidMask = new SnmpObjectId(vendor.getSysoidRootMask());
            String curClassName = vendor.getClassName();
            m_oidMask2IpRouteclassName.put(oidMask.toString(), curClassName);
            LogUtils.debugf((Object)this, (String)"getIpRouteClassNames:  adding class %s for oid %s", (Object[])new Object[]{curClassName, oidMask.toString()});
        }
    }

    private void initializeVlanClassNames() throws IOException, MarshalException, ValidationException {
        Vlans vlans = m_config.getVlans();
        if (vlans == null) {
            LogUtils.infof((Object)this, (String)"no vlans found in config", (Object[])new Object[0]);
        }
        ArrayList<String> excludedOids = new ArrayList<String>();
        for (Vendor vendor : vlans.getVendorCollection()) {
            int[] identifiers;
            SnmpObjectId snmpCurOid;
            SnmpObjectId snmpEndOid;
            SnmpObjectId curRootSysOid = new SnmpObjectId(vendor.getSysoidRootMask());
            String curClassName = vendor.getClassName();
            for (String specific : vendor.getSpecific()) {
                SnmpObjectId oidMask = new SnmpObjectId(specific);
                oidMask.prepend(curRootSysOid);
                m_oidMask2VlanclassName.put(oidMask.toString(), curClassName);
                LogUtils.debugf((Object)this, (String)"getClassNames:  adding class %s for oid %s", (Object[])new Object[]{curClassName, oidMask.toString()});
            }
            for (ExcludeRange excludeRange : vendor.getExcludeRangeCollection()) {
                SnmpObjectId snmpBeginOid = new SnmpObjectId(excludeRange.getBegin());
                snmpEndOid = new SnmpObjectId(excludeRange.getEnd());
                SnmpObjectId snmpRootOid = this.getRootOid(snmpBeginOid);
                if (snmpBeginOid.getLength() != snmpEndOid.getLength() || !snmpRootOid.isRootOf(snmpEndOid)) continue;
                snmpCurOid = new SnmpObjectId(snmpBeginOid);
                while (snmpCurOid.compare(snmpEndOid) <= 0) {
                    excludedOids.add(snmpCurOid.toString());
                    LogUtils.debugf((Object)this, (String)"getClassNames:  signing excluded class %s for oid %s", (Object[])new Object[]{curClassName, curRootSysOid.toString().concat(snmpCurOid.toString())});
                    int lastCurCipher = snmpCurOid.getLastIdentifier();
                    identifiers = snmpCurOid.getIdentifiers();
                    identifiers[identifiers.length - 1] = ++lastCurCipher;
                    snmpCurOid.setIdentifiers(identifiers);
                }
            }
            for (IncludeRange includeRange : vendor.getIncludeRangeCollection()) {
                SnmpObjectId snmpBeginOid = new SnmpObjectId(includeRange.getBegin());
                snmpEndOid = new SnmpObjectId(includeRange.getEnd());
                SnmpObjectId rootOid = this.getRootOid(snmpBeginOid);
                if (snmpBeginOid.getLength() != snmpEndOid.getLength() || !rootOid.isRootOf(snmpEndOid)) continue;
                snmpCurOid = new SnmpObjectId(snmpBeginOid);
                while (snmpCurOid.compare(snmpEndOid) <= 0) {
                    if (!excludedOids.contains(snmpBeginOid.toString())) {
                        SnmpObjectId oidMask = new SnmpObjectId(snmpBeginOid);
                        oidMask.prepend(curRootSysOid);
                        m_oidMask2VlanclassName.put(oidMask.toString(), curClassName);
                        LogUtils.debugf((Object)this, (String)"getClassNames:  adding class %s for oid %s", (Object[])new Object[]{curClassName, oidMask.toString()});
                    }
                    int lastCipher = snmpBeginOid.getLastIdentifier();
                    identifiers = snmpBeginOid.getIdentifiers();
                    identifiers[identifiers.length - 1] = ++lastCipher;
                    snmpCurOid.setIdentifiers(identifiers);
                }
            }
        }
    }

    @Override
    public String getIpRouteClassName(String sysoid) {
        for (String oidMask : m_oidMask2IpRouteclassName.keySet()) {
            if (!sysoid.startsWith(oidMask)) continue;
            return m_oidMask2IpRouteclassName.get(oidMask);
        }
        return DEFAULT_IP_ROUTE_CLASS_NAME;
    }

    @Override
    public String getDefaultIpRouteClassName() {
        return DEFAULT_IP_ROUTE_CLASS_NAME;
    }

    @Override
    public String getVlanClassName(String sysoid) {
        for (String oidMask : m_oidMask2VlanclassName.keySet()) {
            if (!sysoid.startsWith(oidMask)) continue;
            return m_oidMask2VlanclassName.get(oidMask);
        }
        return null;
    }

    @Override
    public boolean hasIpRouteClassName(String sysoid) {
        for (String oidMask : m_oidMask2IpRouteclassName.keySet()) {
            if (!sysoid.startsWith(oidMask)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasClassName(String sysoid) {
        for (String oidMask : m_oidMask2VlanclassName.keySet()) {
            if (!sysoid.startsWith(oidMask)) continue;
            return true;
        }
        return false;
    }

    private SnmpObjectId getRootOid(SnmpObjectId snmpObj) {
        int[] identifiers = snmpObj.getIdentifiers();
        int[] rootIdentifiers = new int[identifiers.length - 1];
        for (int i = 0; i < identifiers.length - 1; ++i) {
            rootIdentifiers[i] = identifiers[i];
        }
        return new SnmpObjectId(rootIdentifiers);
    }

    @Override
    public synchronized boolean interfaceInPackage(String iface, Package pkg) {
        boolean filterPassed = false;
        List<String> ipList = m_pkgIpMap.get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(iface);
        }
        LogUtils.debugf((Object)this, (String)"interfaceInPackage: Interface %s passed filter for package %s?: %s", (Object[])new Object[]{iface, pkg.getName(), filterPassed ? "True" : "False"});
        if (!filterPassed) {
            return false;
        }
        return this.interfaceInPackageRange(iface, pkg);
    }

    @Override
    public synchronized boolean interfaceInPackageRange(String iface, Package pkg) {
        byte[] end;
        byte[] start;
        String url;
        if (pkg == null) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        ByteArrayComparator comparator = new ByteArrayComparator();
        has_range_include = pkg.getIncludeRangeCount() == 0 && pkg.getSpecificCount() == 0;
        for (String spec : pkg.getSpecificCollection()) {
            byte[] speca = InetAddressUtils.toIpAddrBytes((String)spec);
            if (comparator.compare(speca, addr) != 0) continue;
            has_specific = true;
            break;
        }
        if (has_specific) {
            return true;
        }
        Iterator i$ = pkg.getIncludeUrlCollection().iterator();
        while (i$.hasNext() && !(has_specific = this.interfaceInUrl(iface, url = (String)i$.next()))) {
        }
        if (has_specific) {
            return true;
        }
        if (!has_range_include) {
            for (IncludeRange rng : pkg.getIncludeRangeCollection()) {
                start = InetAddressUtils.toIpAddrBytes((String)rng.getBegin());
                if (comparator.compare(addr, start) > 0) {
                    end = InetAddressUtils.toIpAddrBytes((String)rng.getEnd());
                    if (comparator.compare(addr, end) > 0) continue;
                    has_range_include = true;
                    break;
                }
                if (comparator.compare(addr, start) != 0) continue;
                has_range_include = true;
                break;
            }
        }
        for (IncludeRange rng : pkg.getExcludeRangeCollection()) {
            start = InetAddressUtils.toIpAddrBytes((String)rng.getBegin());
            if (comparator.compare(addr, start) > 0) {
                end = InetAddressUtils.toIpAddrBytes((String)rng.getEnd());
                if (comparator.compare(addr, end) > 0) continue;
                has_range_exclude = true;
                break;
            }
            if (comparator.compare(addr, start) != 0) continue;
            has_range_exclude = true;
            break;
        }
        return has_range_include && !has_range_exclude;
    }

    private boolean interfaceInUrl(String addr, String url) {
        List<String> iplist = m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            return iplist.contains(addr);
        }
        return false;
    }

    @Deprecated
    protected synchronized void reloadXML(Reader reader) throws MarshalException, ValidationException, IOException {
        m_config = (LinkdConfiguration)CastorUtils.unmarshal(LinkdConfiguration.class, (Reader)reader);
        this.createUrlIpMap();
        this.createPackageIpListMap();
        this.initializeVlanClassNames();
        this.initializeIpRouteClassNames();
    }

    protected synchronized void reloadXML(InputStream stream) throws MarshalException, ValidationException, IOException {
        m_config = (LinkdConfiguration)CastorUtils.unmarshal(LinkdConfiguration.class, (InputStream)stream, (boolean)false);
        this.createUrlIpMap();
        this.createPackageIpListMap();
        this.initializeVlanClassNames();
        this.initializeIpRouteClassNames();
    }

    @Override
    public synchronized void save() throws MarshalException, IOException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)m_config, (Writer)stringWriter);
        this.saveXml(stringWriter.toString());
        this.update();
    }

    @Override
    public synchronized Package getFirstPackageMatch(String ipaddr) {
        for (Package pkg : m_config.getPackageCollection()) {
            if (!this.interfaceInPackage(ipaddr, pkg)) continue;
            return pkg;
        }
        return null;
    }

    @Override
    public synchronized List<String> getAllPackageMatches(String ipaddr) {
        ArrayList<String> matchingPkgs = new ArrayList<String>();
        for (Package pkg : m_config.getPackageCollection()) {
            String pkgName = pkg.getName();
            if (!this.interfaceInPackage(ipaddr, pkg)) continue;
            matchingPkgs.add(pkgName);
        }
        return matchingPkgs;
    }

    @Override
    public Enumeration<Package> enumeratePackage() {
        return this.getConfiguration().enumeratePackage();
    }

    @Override
    public boolean forceIpRouteDiscoveryOnEthernet() {
        if (m_config.hasForceIpRouteDiscoveryOnEthernet()) {
            return m_config.getForceIpRouteDiscoveryOnEthernet();
        }
        return false;
    }

    static {
        m_urlIPMap = new HashMap<String, List<String>>();
        m_pkgIpMap = new HashMap<Package, List<String>>();
        m_oidMask2VlanclassName = new HashMap<String, String>();
        m_oidMask2IpRouteclassName = new HashMap<String, String>();
    }
}

