/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.LinkdConfigManager;

public final class LinkdConfigFactory
extends LinkdConfigManager {
    private static LinkdConfig m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;

    @Deprecated
    public LinkdConfigFactory(long currentVersion, Reader reader) throws MarshalException, ValidationException, IOException {
        super(reader);
        this.m_currentVersion = currentVersion;
    }

    public LinkdConfigFactory(long currentVersion, InputStream stream) throws MarshalException, ValidationException, IOException {
        super(stream);
        this.m_currentVersion = currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
        LinkdConfigFactory.logStatic().debug("init: config file path: " + cfgFile.getPath());
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(cfgFile);
            LinkdConfigFactory config = new LinkdConfigFactory(cfgFile.lastModified(), stream);
            LinkdConfigFactory.setInstance(config);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    private static ThreadCategory logStatic() {
        return ThreadCategory.getInstance(LinkdConfigFactory.class);
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        LinkdConfigFactory.init();
        LinkdConfigFactory.getInstance().update();
    }

    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            long timestamp = System.currentTimeMillis();
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
            LinkdConfigFactory.logStatic().debug("saveXml: saving config file at " + timestamp + ": " + cfgFile.getPath());
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
            LinkdConfigFactory.logStatic().debug("saveXml: finished saving config file: " + cfgFile.getPath());
        }
    }

    public static synchronized LinkdConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(LinkdConfig instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
        if (cfgFile.lastModified() > this.m_currentVersion) {
            this.m_currentVersion = cfgFile.lastModified();
            LinkdConfigFactory.logStatic().debug("init: config file path: " + cfgFile.getPath());
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(cfgFile);
                this.reloadXML(stream);
            }
            finally {
                if (stream != null) {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
            LinkdConfigFactory.logStatic().debug("init: finished loading config file: " + cfgFile.getPath());
        }
    }
}

