/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.Serializable;
import javax.servlet.http.HttpSession;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.dao.castor.CastorUtils;

public class KscReportEditor
implements Serializable {
    private static final long serialVersionUID = 8825116321880022485L;
    private Report m_workingReport = null;
    private int m_workingGraphIndex = -1;
    private Graph m_workingGraph = null;

    private static Report getNewReport() {
        Report new_report = new Report();
        new_report.setTitle("New Report Title");
        new_report.setShow_graphtype_button(false);
        new_report.setShow_timespan_button(false);
        return new_report;
    }

    public Report getWorkingReport() {
        return this.m_workingReport;
    }

    public Graph getWorkingGraph() {
        return this.m_workingGraph;
    }

    public int getWorkingGraphIndex() {
        return this.m_workingGraphIndex;
    }

    private static Graph getNewGraph() {
        Graph new_graph = new Graph();
        new_graph.setTitle("");
        new_graph.setTimespan("7_day");
        return new_graph;
    }

    public void loadWorkingGraph(int index) throws MarshalException, ValidationException {
        int total_graphs = this.m_workingReport.getGraphCount();
        this.m_workingGraphIndex = index;
        if (this.m_workingGraphIndex < 0 || this.m_workingGraphIndex >= total_graphs) {
            this.m_workingGraph = KscReportEditor.getNewGraph();
            this.m_workingGraphIndex = -1;
        } else {
            this.m_workingGraph = (Graph)CastorUtils.duplicateObject((Object)this.m_workingReport.getGraph(this.m_workingGraphIndex), Graph.class);
        }
    }

    public void unloadWorkingGraph(int requested_graphnum) throws MarshalException, ValidationException {
        int total_graphs = this.m_workingReport.getGraphCount();
        int insert_location = requested_graphnum--;
        if (this.m_workingGraphIndex >= 0 && this.m_workingGraphIndex < total_graphs) {
            this.m_workingReport.removeGraph(this.m_workingReport.getGraph(this.m_workingGraphIndex));
        }
        if (insert_location < 0 || insert_location >= total_graphs) {
            this.m_workingReport.addGraph(this.m_workingGraph);
        } else {
            this.m_workingReport.addGraph(insert_location, this.m_workingGraph);
        }
        this.m_workingGraph = KscReportEditor.getNewGraph();
        this.m_workingGraphIndex = -1;
    }

    public void loadWorkingReport(Report report) throws MarshalException, ValidationException {
        this.m_workingReport = (Report)CastorUtils.duplicateObject((Object)report, Report.class);
        this.m_workingReport.deleteId();
    }

    public void loadWorkingReport(KSC_PerformanceReportFactory factory, int index) throws MarshalException, ValidationException {
        Report report = factory.getReportByIndex(index);
        if (report == null) {
            throw new IllegalArgumentException("Could not find report with ID " + index);
        }
        this.m_workingReport = (Report)CastorUtils.duplicateObject((Object)report, Report.class);
    }

    public void loadWorkingReportDuplicate(KSC_PerformanceReportFactory factory, int index) throws MarshalException, ValidationException {
        this.loadWorkingReport(factory, index);
        this.m_workingReport.deleteId();
    }

    public void loadNewWorkingReport() {
        this.m_workingReport = KscReportEditor.getNewReport();
        this.m_workingReport.deleteId();
    }

    public void unloadWorkingReport(KSC_PerformanceReportFactory factory) throws MarshalException, ValidationException {
        if (this.getWorkingReport().hasId()) {
            factory.setReport(this.getWorkingReport().getId(), this.getWorkingReport());
        } else {
            factory.addReport(this.getWorkingReport());
        }
        this.loadNewWorkingReport();
    }

    public static KscReportEditor getFromSession(HttpSession session, boolean required) {
        String attributeName = KscReportEditor.class.getName();
        if (session.getAttribute(attributeName) == null) {
            if (required) {
                throw new IllegalStateException("The KSC report editing session is not open--please restart your edits.  This could be due to your session expiring on the server due to inactivity or the server being restarted.");
            }
            session.setAttribute(attributeName, (Object)new KscReportEditor());
        }
        return (KscReportEditor)session.getAttribute(attributeName);
    }

    public static void unloadFromSession(HttpSession session) {
        String attributeName = KscReportEditor.class.getName();
        session.removeAttribute(attributeName);
    }
}

