/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.httpdatacollection.HttpCollection;
import org.opennms.netmgt.config.httpdatacollection.HttpDatacollectionConfig;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.model.RrdRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpCollectionConfigFactory {
    private static HttpCollectionConfigFactory m_instance;
    private static boolean m_loadedFromFile;
    protected boolean initialized = false;
    protected static long m_lastModified;
    private static HttpDatacollectionConfig m_config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpCollectionConfigFactory(String configFile) throws MarshalException, ValidationException, IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(configFile);
            this.initialize(is);
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    @Deprecated
    public HttpCollectionConfigFactory(Reader rdr) throws MarshalException, ValidationException {
        this.initialize(rdr);
    }

    public HttpCollectionConfigFactory(InputStream stream) throws MarshalException, ValidationException {
        this.initialize(stream);
    }

    private void initialize(InputStream stream) throws MarshalException, ValidationException {
        this.log().debug("initialize: initializing http collection config factory.");
        m_config = (HttpDatacollectionConfig)CastorUtils.unmarshal(HttpDatacollectionConfig.class, (InputStream)stream);
    }

    @Deprecated
    private void initialize(Reader rdr) throws MarshalException, ValidationException {
        this.log().debug("initialize: initializing http collection config factory.");
        m_config = (HttpDatacollectionConfig)CastorUtils.unmarshal(HttpDatacollectionConfig.class, (Reader)rdr);
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (m_instance == null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.HTTP_COLLECTION_CONFIG_FILE_NAME);
            m_instance = new HttpCollectionConfigFactory(cfgFile.getPath());
            m_lastModified = cfgFile.lastModified();
            m_loadedFromFile = true;
        }
    }

    public static synchronized HttpCollectionConfigFactory getInstance() {
        if (m_instance == null) {
            throw new IllegalStateException("You must call HttpCollectionConfigFactory.init() before calling getInstance().");
        }
        return m_instance;
    }

    public static synchronized void setInstance(HttpCollectionConfigFactory instance) {
        m_instance = instance;
        m_loadedFromFile = false;
    }

    public synchronized void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        m_instance = null;
        HttpCollectionConfigFactory.init();
    }

    protected void updateFromFile() throws IOException, MarshalException, ValidationException {
        File surveillanceViewsFile;
        if (m_loadedFromFile && m_lastModified != (surveillanceViewsFile = ConfigFileConstants.getFile((int)ConfigFileConstants.HTTP_COLLECTION_CONFIG_FILE_NAME)).lastModified()) {
            this.reload();
        }
    }

    public static synchronized HttpDatacollectionConfig getConfig() {
        return m_config;
    }

    public static synchronized void setConfig(HttpDatacollectionConfig m_config) {
        HttpCollectionConfigFactory.m_config = m_config;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance();
    }

    public HttpCollection getHttpCollection(String collectionName) {
        List collections = m_config.getHttpCollectionCollection();
        HttpCollection collection = null;
        for (HttpCollection coll : collections) {
            if (!coll.getName().equalsIgnoreCase(collectionName)) continue;
            collection = coll;
            break;
        }
        if (collection == null) {
            throw new IllegalArgumentException("getHttpCollection: collection name: " + collectionName + " specified in collectd configuration not found in http collection configuration.");
        }
        return collection;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdPath()));
        repo.setRraList(this.getRRAList(collectionName));
        repo.setStep(this.getStep(collectionName));
        repo.setHeartBeat(2 * this.getStep(collectionName));
        return repo;
    }

    public int getStep(String cName) {
        HttpCollection collection = this.getHttpCollection(cName);
        if (collection != null) {
            return collection.getRrd().getStep();
        }
        return -1;
    }

    public List<String> getRRAList(String cName) {
        HttpCollection collection = this.getHttpCollection(cName);
        if (collection != null) {
            return collection.getRrd().getRraCollection();
        }
        return null;
    }

    public String getRrdPath() {
        String rrdPath = m_config.getRrdRepository();
        if (rrdPath == null) {
            throw new RuntimeException("Configuration error, failed to retrieve path to RRD repository.");
        }
        if (rrdPath.endsWith(File.separator)) {
            rrdPath = rrdPath.substring(0, rrdPath.length() - File.separator.length());
        }
        return rrdPath;
    }

    static {
        m_loadedFromFile = false;
    }
}

