/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.DBTools;
import org.opennms.netmgt.capsd.AbstractPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "JDBC";
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    public JDBCPlugin() {
        LogUtils.debugf((Object)this, (String)"JDBCPlugin class loaded", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(String hostname, Map<String, Object> qualifiers) {
        String user = ParameterMap.getKeyedString(qualifiers, (String)"user", (String)"sa");
        String password = ParameterMap.getKeyedString(qualifiers, (String)"password", (String)"");
        String db_url = ParameterMap.getKeyedString(qualifiers, (String)"url", (String)"jdbc:sybase:Tds:OPENNMS_JDBC_HOSTNAME/tempdb");
        int timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
        int retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
        String db_driver = ParameterMap.getKeyedString(qualifiers, (String)"driver", (String)"com.sybase.jdbc2.jdbc.SybDriver");
        boolean status = false;
        Connection con = null;
        Statement statement = null;
        boolean connected = false;
        int attempts = 0;
        while (attempts <= retries && !connected) {
            LogUtils.infof((Object)this, (String)"Trying to detect JDBC server on '%s', attempt #: %d", (Object[])new Object[]{hostname, attempts});
            try {
                LogUtils.infof((Object)this, (String)"Loading JDBC driver: '%s'", (Object[])new Object[]{db_driver});
                Driver driver = (Driver)Class.forName(db_driver).newInstance();
                LogUtils.debugf((Object)this, (String)"JDBC driver loaded: '%s'", (Object[])new Object[]{db_driver});
                String url = DBTools.constructUrl(db_url, hostname);
                LogUtils.debugf((Object)this, (String)"Constructed JDBC url: '%s'", (Object[])new Object[]{url});
                Properties props = new Properties();
                props.setProperty("user", user);
                props.setProperty("password", password);
                props.setProperty("timeout", String.valueOf(timeout / 1000));
                con = driver.connect(url, props);
                connected = true;
                LogUtils.debugf((Object)this, (String)"Got database connection: '%s' (%s, %s, %s)", (Object[])new Object[]{con, url, user, password});
                status = this.checkStatus(con, qualifiers);
                if (status) {
                    LogUtils.infof((Object)this, (String)"JDBC server detected on: '%s', attempt #: %d", (Object[])new Object[]{hostname, attempts});
                }
                ++attempts;
                this.closeStmt(statement);
                this.closeConn(con);
            }
            catch (Exception e) {
                LogUtils.infof((Object)this, (Throwable)e, (String)"failed to make JDBC connection", (Object[])new Object[0]);
            }
            finally {
                ++attempts;
                this.closeStmt(statement);
                this.closeConn(con);
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkStatus(Connection con, Map<String, Object> qualifiers) {
        boolean status = false;
        ResultSet result = null;
        try {
            DatabaseMetaData metadata = con.getMetaData();
            LogUtils.debugf((Object)this, (String)"Got database metadata", (Object[])new Object[0]);
            result = metadata.getCatalogs();
            while (result.next()) {
                result.getString(1);
                LogUtils.debugf((Object)this, (String)"Metadata catalog: '%s'", (Object[])new Object[]{result.getString(1)});
            }
            if (result != null) {
                status = true;
            }
            this.closeResult(result);
        }
        catch (SQLException sqlException) {
            try {
                LogUtils.warnf((Object)this, (Throwable)sqlException, (String)"error while getting database metadata", (Object[])new Object[0]);
                this.closeResult(result);
            }
            catch (Throwable throwable) {
                this.closeResult(result);
                throw throwable;
            }
        }
        return status;
    }

    private void closeConn(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeResult(ResultSet result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        boolean status = false;
        try {
            status = this.isServer(address.getCanonicalHostName(), new HashMap<String, Object>());
        }
        catch (Exception exp) {
            LogUtils.errorf((Object)this, (Throwable)exp, (String)"an error occurred while checking whether the protocol is supported", (Object[])new Object[0]);
        }
        return status;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        boolean status = false;
        if (address == null) {
            throw new NullPointerException(this.getClass().getName() + ": Internet address cannot be null");
        }
        if (qualifiers == null) {
            throw new NullPointerException(this.getClass().getName() + ": Map argument cannot be null");
        }
        try {
            status = this.isServer(address.getCanonicalHostName(), qualifiers);
        }
        catch (Exception exp) {
            LogUtils.errorf((Object)this, (Throwable)exp, (String)"an error occurred while checking if the protocol is supported", (Object[])new Object[0]);
        }
        return status;
    }
}

