/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import org.opennms.netmgt.capsd.AbstractTcpPlugin;
import org.opennms.netmgt.capsd.ConnectionConfig;

public final class ImapPlugin
extends AbstractTcpPlugin {
    private static final int DEFAULT_PORT = 143;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static String IMAP_BYE_RESPONSE_PREFIX = "* BYE ";
    private static String IMAP_LOGOUT_REQUEST = "ONMSCAPSD LOGOUT\r\n";
    private static String IMAP_LOGOUT_RESPONSE_PREFIX = "ONMSCAPSD OK ";
    private static String IMAP_START_RESPONSE_PREFIX = "* OK ";
    private static final String PROTOCOL_NAME = "IMAP";

    public ImapPlugin() {
        super(PROTOCOL_NAME, 143, 5000, 0);
    }

    protected boolean checkProtocol(Socket socket, ConnectionConfig config) throws IOException {
        boolean isAServer = false;
        BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String banner = lineRdr.readLine();
        if (banner != null && banner.startsWith(IMAP_START_RESPONSE_PREFIX)) {
            socket.getOutputStream().write(IMAP_LOGOUT_REQUEST.getBytes());
            String response = lineRdr.readLine();
            if (response != null && response.startsWith(IMAP_BYE_RESPONSE_PREFIX) && (response = lineRdr.readLine()) != null && response.startsWith(IMAP_LOGOUT_RESPONSE_PREFIX)) {
                isAServer = true;
            }
        }
        return isAServer;
    }
}

