/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import org.opennms.netmgt.capsd.AbstractTcpPlugin;
import org.opennms.netmgt.capsd.ConnectionConfig;
import org.opennms.netmgt.capsd.plugins.FtpResponse;

public final class FtpPlugin
extends AbstractTcpPlugin {
    private static final int DEFAULT_PORT = 21;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final String PROTOCOL_NAME = "FTP";

    public FtpPlugin() {
        super(PROTOCOL_NAME, 21, 5000, 0);
    }

    protected boolean checkProtocol(Socket socket, ConnectionConfig config) throws IOException {
        BufferedReader rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        FtpResponse connectResponse = FtpResponse.readResponse(rdr);
        if (!connectResponse.isCodeValid()) {
            return false;
        }
        FtpResponse.sendCommand(socket, "QUIT");
        FtpResponse quitResponse = FtpResponse.readResponse(rdr);
        return quitResponse.isCodeValid();
    }
}

