/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.actiond;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Executor
implements Runnable,
PausableFiber {
    private FifoQueue<String> m_execQ;
    private List<DatedProc> m_processes = Collections.synchronizedList(new LinkedList());
    private long m_maxWait;
    private int m_maxProcCount;
    private Thread m_reaper;
    private Runnable m_reaperRun;
    private Thread m_worker;
    private String m_name;
    private int m_status;

    private static String[] getExecArguments(String cmd) {
        ThreadCategory log = ThreadCategory.getInstance(Executor.class);
        cmd = cmd.trim();
        StringBuffer buf = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>(5);
        char[] chars = cmd.toCharArray();
        boolean dquoted = false;
        boolean squoted = false;
        for (int x = 0; x < chars.length; ++x) {
            if (chars[x] == '\\') {
                if (squoted) {
                    buf.append(chars[x]).append(chars[x + 1]);
                    x += 2;
                    continue;
                }
                buf.append(chars[++x]);
                continue;
            }
            if (chars[x] == '\"' && !squoted) {
                dquoted = !dquoted;
                continue;
            }
            if (chars[x] == '\'' && !dquoted) {
                squoted = !squoted;
                continue;
            }
            if (squoted || dquoted) {
                buf.append(chars[x]);
                continue;
            }
            if (chars[x] == ' ') {
                String arg = buf.toString().trim();
                if (log.isDebugEnabled()) {
                    log.debug("getExecArgument: adding argument: " + arg);
                }
                args.add(arg);
                buf.delete(0, buf.length());
                while (chars[x + 1] == ' ') {
                    ++x;
                }
                continue;
            }
            buf.append(chars[x]);
        }
        if (buf.length() > 0) {
            args.add(buf.toString());
        }
        buf = null;
        String[] results = new String[args.size()];
        return args.toArray(results);
    }

    Executor(FifoQueue<String> execQ, long maxRunTime, int maxProcesses) {
        this.m_execQ = execQ;
        this.m_maxWait = maxRunTime;
        this.m_worker = null;
        this.m_reaper = null;
        this.m_name = "Actiond-Executor";
        this.m_status = 0;
        this.m_reaperRun = null;
        this.m_maxProcCount = maxProcesses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadCategory log = ThreadCategory.getInstance(Executor.class);
        Runnable runnable = this;
        synchronized (runnable) {
            this.m_status = 2;
        }
        while (true) {
            String[] execArgs;
            runnable = this;
            synchronized (runnable) {
                if (this.m_status == 3 || this.m_status == 4) {
                    break;
                }
                while (this.m_status == 5 || this.m_status == 6) {
                    this.m_status = 6;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
                if (this.m_status == 7) {
                    this.m_status = 2;
                }
            }
            if (this.m_maxProcCount == this.m_processes.size()) {
                if (log.isDebugEnabled()) {
                    log.debug("Number of processes at " + this.m_maxProcCount + " - being wait for a process to finish or be reaped!");
                }
                runnable = this.m_reaperRun;
                synchronized (runnable) {
                    this.m_reaperRun.notifyAll();
                    try {
                        this.m_reaperRun.wait();
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
            String cmd = null;
            try {
                cmd = (String)this.m_execQ.remove(1000L);
                if (cmd == null) {
                    continue;
                }
            }
            catch (InterruptedException ex) {
                break;
            }
            catch (FifoQueueException ex) {
                log.warn("The input execution queue has errors, exiting...", (Throwable)ex);
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug("Parsing cmd args: " + cmd);
            }
            if ((execArgs = Executor.getExecArguments(cmd)) == null || execArgs.length <= 0) continue;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Getting ready to execute '" + cmd + "'");
                }
                Process px = Runtime.getRuntime().exec(execArgs);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.m_processes.add(new DatedProc(cmd, px));
                continue;
            }
            catch (IOException ex) {
                log.warn("Failed to execute command: " + cmd, (Throwable)ex);
                continue;
            }
            catch (SecurityException ex) {
                log.warn("Application not authorized to exec commands!", (Throwable)ex);
            }
            break;
        }
        runnable = this;
        synchronized (runnable) {
            this.m_status = 4;
        }
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already be run");
        }
        this.m_status = 1;
        this.m_reaperRun = new Reaper();
        this.m_reaper = new Thread(this.m_reaperRun, this.getName() + "-Reaper");
        this.m_reaper.setDaemon(true);
        this.m_reaper.start();
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
    }

    public synchronized void stop() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been run");
        }
        if (this.m_status != 4) {
            this.m_status = 3;
        }
        if (this.m_reaper.isAlive()) {
            this.m_reaper.interrupt();
        }
        if (this.m_worker.isAlive()) {
            this.m_worker.interrupt();
        }
        this.notifyAll();
    }

    public synchronized void pause() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        if (this.m_status == 2 || this.m_status == 7) {
            this.m_status = 5;
            this.notifyAll();
        }
    }

    public synchronized void resume() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        if (this.m_status == 6 || this.m_status == 5) {
            this.m_status = 7;
            this.notifyAll();
        }
    }

    public String getName() {
        return this.m_name;
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            if (this.m_reaper.isAlive()) {
                this.m_reaper.interrupt();
            }
            this.m_status = 4;
        }
        return this.m_status;
    }

    private final class Reaper
    implements Runnable {
        private Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long waitPeriod = Executor.this.m_maxWait / 5L;
            if (waitPeriod > 15000L) {
                waitPeriod = 15000L;
            }
            ThreadCategory log = ThreadCategory.getInstance(Executor.class);
            while (true) {
                Object object = Executor.this.m_processes;
                synchronized (object) {
                    Iterator i = Executor.this.m_processes.iterator();
                    while (i.hasNext()) {
                        DatedProc dp = (DatedProc)i.next();
                        try {
                            int rc = dp.getProcess().exitValue();
                            if (log.isDebugEnabled()) {
                                log.debug("Process " + dp + " completed, rc = " + rc);
                            }
                            i.remove();
                        }
                        catch (IllegalThreadStateException ex) {
                            if (dp.getRunTime() <= Executor.this.m_maxWait) continue;
                            if (log.isInfoEnabled()) {
                                log.info("Process " + dp + " did not complete in the alloted time, terminating.");
                            }
                            dp.getProcess().destroy();
                            i.remove();
                        }
                    }
                }
                object = this;
                synchronized (object) {
                    this.notifyAll();
                    try {
                        this.wait(waitPeriod);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        }
    }

    private static final class DatedProc {
        private final String m_cmd;
        private final Process m_proc;
        private final long m_started;

        DatedProc(String cmd, Process p) {
            this.m_cmd = cmd;
            this.m_proc = p;
            this.m_started = System.currentTimeMillis();
        }

        Process getProcess() {
            return this.m_proc;
        }

        long getRunTime() {
            return System.currentTimeMillis() - this.m_started;
        }

        public String toString() {
            return this.m_cmd;
        }
    }
}

