/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.javamail;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.MimeBodyPart;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.javamail.JavaMailerException;
import org.springframework.util.StringUtils;

public abstract class JavaMailer2 {
    private Session m_session = null;
    private Properties m_mailProps;

    public JavaMailer2(Properties javamailProps) throws JavaMailerException {
    }

    public JavaMailer2() throws JavaMailerException {
        this(new Properties());
    }

    public Authenticator createAuthenticator(final String user, final String password) {
        Authenticator auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, password);
            }
        };
        return auth;
    }

    public MimeBodyPart createFileAttachment(File file) throws MessagingException, JavaMailerException {
        if (!file.exists()) {
            JavaMailer2.log().error("File attachment '" + file.getAbsolutePath() + "' does not exist.");
            throw new JavaMailerException("File attachment '" + file.getAbsolutePath() + "' does not exist.");
        }
        if (!file.canRead()) {
            JavaMailer2.log().error("File attachment '" + file.getAbsolutePath() + "' is not readable.");
            throw new JavaMailerException("File attachment '" + file.getAbsolutePath() + "' is not readable.");
        }
        MimeBodyPart bodyPart = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(file);
        bodyPart.setDataHandler(new DataHandler((DataSource)fds));
        bodyPart.setFileName(fds.getName());
        return bodyPart;
    }

    public void setDebug(boolean debug) {
        if (debug) {
            this.m_session.setDebugOut(new PrintStream(new LoggingByteArrayOutputStream(JavaMailer2.log()), true));
        }
        this.m_session.setDebug(debug);
    }

    protected static ThreadCategory log() {
        return ThreadCategory.getInstance();
    }

    public Session getSession() {
        return this.m_session;
    }

    public void setSession(Session session) {
        this.m_session = session;
    }

    public Properties getMailProps() {
        return this.m_mailProps;
    }

    public static class LoggingTransportListener
    implements TransportListener {
        private ThreadCategory m_category;
        private List<Address> m_invalidAddresses = new ArrayList<Address>();
        private List<Address> m_validSentAddresses = new ArrayList<Address>();
        private List<Address> m_validUnsentAddresses = new ArrayList<Address>();

        public LoggingTransportListener(ThreadCategory threadCategory) {
            this.m_category = threadCategory;
        }

        public void messageDelivered(TransportEvent event) {
            this.logEvent("message delivered", event);
        }

        public void messageNotDelivered(TransportEvent event) {
            this.logEvent("message not delivered", event);
        }

        public void messagePartiallyDelivered(TransportEvent event) {
            this.logEvent("message partially delivered", event);
        }

        private void logEvent(String message, TransportEvent event) {
            if (event.getInvalidAddresses() != null && event.getInvalidAddresses().length > 0) {
                this.m_invalidAddresses.addAll(Arrays.asList(event.getInvalidAddresses()));
                this.m_category.error(message + ": invalid addresses: " + StringUtils.arrayToDelimitedString((Object[])event.getInvalidAddresses(), (String)", "));
            }
            if (event.getValidSentAddresses() != null && event.getValidSentAddresses().length > 0) {
                this.m_validSentAddresses.addAll(Arrays.asList(event.getValidSentAddresses()));
                this.m_category.debug(message + ": valid sent addresses: " + StringUtils.arrayToDelimitedString((Object[])event.getValidSentAddresses(), (String)", "));
            }
            if (event.getValidUnsentAddresses() != null && event.getValidUnsentAddresses().length > 0) {
                this.m_validUnsentAddresses.addAll(Arrays.asList(event.getValidUnsentAddresses()));
                this.m_category.error(message + ": valid unsent addresses: " + StringUtils.arrayToDelimitedString((Object[])event.getValidUnsentAddresses(), (String)", "));
            }
        }

        public boolean hasAnythingBeenReceived() {
            return this.m_invalidAddresses.size() != 0 || this.m_validSentAddresses.size() != 0 || this.m_validUnsentAddresses.size() != 0;
        }

        public void assertAllMessagesDelivered() throws JavaMailerException {
            for (int i = 0; i < 10 && !this.hasAnythingBeenReceived(); ++i) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_invalidAddresses.size() == 0 && this.m_validUnsentAddresses.size() == 0) {
                return;
            }
            throw new JavaMailerException("Not all messages delivered:\n\t" + this.m_validSentAddresses.size() + " messages were sent to valid addresses: " + StringUtils.collectionToDelimitedString(this.m_validSentAddresses, (String)", ") + "\n" + "\t" + this.m_validUnsentAddresses.size() + " messages were not sent to valid addresses: " + StringUtils.collectionToDelimitedString(this.m_validUnsentAddresses, (String)", ") + "\n" + "\t" + this.m_invalidAddresses.size() + " messages had invalid addresses: " + StringUtils.collectionToDelimitedString(this.m_invalidAddresses, (String)", "));
        }
    }

    public static class LoggingByteArrayOutputStream
    extends ByteArrayOutputStream {
        private ThreadCategory m_category;

        public LoggingByteArrayOutputStream(ThreadCategory threadCategory) {
            this.m_category = threadCategory;
        }

        public void flush() throws IOException {
            super.flush();
            String buffer = this.toString().replaceAll("\n", "");
            if (buffer.length() > 0) {
                this.m_category.debug(buffer);
            }
            this.reset();
        }
    }
}

