/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.poller.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.poller.remote.AuthenticationBean;
import org.opennms.poller.remote.GroovyGui;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class Main {
    String[] m_args;
    ClassPathXmlApplicationContext m_context;
    PollerFrontEnd m_frontEnd;
    URI m_uri;
    String m_locationName;
    String m_username = null;
    String m_password = null;
    String m_pollerHome = null;
    boolean m_shuttingDown = false;
    boolean m_gui = false;
    CommandLine m_cl;

    private Main(String[] args) throws Exception {
        this.m_args = args;
        this.m_pollerHome = System.getProperty("poller.home");
        if (this.m_pollerHome == null) {
            this.m_pollerHome = System.getProperty("os.name").contains("Windows") ? System.getProperty("java.io.tmpdir") : System.getProperty("user.home") + File.separator + ".opennms";
        }
        this.initializeLogging();
    }

    private void initializeLogging() throws Exception {
        String logFile = System.getProperty("poller.logfile", this.m_pollerHome + File.separator + "opennms-remote-poller.log");
        File logDirectory = new File(logFile).getParentFile();
        if (!logDirectory.exists() && !logDirectory.mkdirs()) {
            throw new IllegalStateException("Could not create parent directory for log file '" + logFile + "'");
        }
        if (Boolean.getBoolean("debug")) {
            LogUtils.logToConsole();
        } else {
            LogUtils.logToFile((String)logFile);
        }
    }

    private void getAuthenticationInfo() {
        if (this.m_uri == null || this.m_uri.getScheme() == null) {
            throw new RuntimeException("no URI specified!");
        }
        if (this.m_uri.getScheme().equals("rmi")) {
            return;
        }
        if (this.m_username == null) {
            GroovyGui gui = this.createGui();
            gui.createAndShowGui();
            AuthenticationBean auth = gui.getAuthenticationBean();
            this.m_username = auth.getUsername();
            this.m_password = auth.getPassword();
        }
        if (this.m_username != null) {
            SecurityContextHolder.setStrategyName((String)"MODE_GLOBAL");
            SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)this.m_username, (Object)this.m_password));
        }
    }

    private GroovyGui createGui() {
        try {
            return (GroovyGui)Class.forName("org.opennms.groovy.poller.remote.ConfigurationGui").newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find Configuration GUI!", e);
        }
    }

    private void run() {
        try {
            this.parseArguments();
            this.getAuthenticationInfo();
            this.createAppContext();
            this.registerShutDownHook();
            if (!this.m_gui && !this.m_frontEnd.isRegistered()) {
                if (this.m_locationName == null) {
                    LogUtils.errorf((Object)this, (String)"No location name provided.  You must pass a location name the first time you start the remote poller!", (Object[])new Object[0]);
                    System.exit(27);
                } else {
                    this.m_frontEnd.register(this.m_locationName);
                }
            }
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Exception occurred during registration!", (Object[])new Object[0]);
            System.exit(27);
        }
    }

    private void parseArguments() throws ParseException {
        Options options = new Options();
        options.addOption("h", "help", false, "this help");
        options.addOption("d", "debug", false, "write debug messages to the log");
        options.addOption("g", "gui", false, "start a GUI (default: false)");
        options.addOption("l", "location", true, "the location name of this remote poller");
        options.addOption("u", "url", true, "the URL for OpenNMS (default: rmi://server-name/)");
        options.addOption("n", "name", true, "the name of the user to connect as");
        options.addOption("p", "password", true, "the password to use when connecting");
        PosixParser parser = new PosixParser();
        this.m_cl = parser.parse(options, this.m_args);
        if (this.m_cl.hasOption("h")) {
            this.usage(options);
            System.exit(1);
        }
        if (this.m_cl.hasOption("d")) {
            LogUtils.enableDebugging();
        }
        if (this.m_cl.hasOption("l")) {
            this.m_locationName = this.m_cl.getOptionValue("l");
        }
        if (this.m_cl.hasOption("u")) {
            String arg = this.m_cl.getOptionValue("u").toLowerCase();
            try {
                this.m_uri = new URI(arg);
            }
            catch (URISyntaxException e) {
                this.usage(options);
                e.printStackTrace();
                System.exit(2);
            }
        } else {
            this.usage(options);
            System.exit(3);
        }
        if (this.m_cl.hasOption("g")) {
            this.m_gui = true;
        }
        if (this.m_cl.hasOption("n")) {
            this.m_username = this.m_cl.getOptionValue("n");
            this.m_password = this.m_cl.getOptionValue("p");
            if (this.m_password == null) {
                this.m_password = "";
            }
        }
    }

    private void usage(Options o) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("usage: ", o);
    }

    private void registerShutDownHook() {
        Thread shutdownHook = new Thread(){

            public void run() {
                Main.this.m_shuttingDown = true;
                Main.this.m_context.close();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private void createAppContext() {
        File homeDir = new File(System.getProperty("user.home"));
        String homeUrl = homeDir.toURI().toString();
        if (homeUrl.endsWith("/")) {
            homeUrl = homeUrl.substring(0, homeUrl.length() - 1);
        }
        LogUtils.infof((Object)this, (String)"user.home.url = %s", (Object[])new Object[]{homeUrl});
        System.setProperty("user.home.url", homeUrl);
        String serverURI = this.m_uri.toString().replaceAll("/*$", "");
        LogUtils.infof((Object)this, (String)"opennms.poller.server.url = %s", (Object[])new Object[]{serverURI});
        System.setProperty("opennms.poller.server.url", serverURI);
        LogUtils.infof((Object)this, (String)"location name = %s", (Object[])new Object[]{this.m_locationName});
        ArrayList<String> configs = new ArrayList<String>();
        configs.add("classpath:/META-INF/opennms/applicationContext-remotePollerBackEnd-" + this.m_uri.getScheme() + ".xml");
        configs.add("classpath:/META-INF/opennms/applicationContext-pollerFrontEnd.xml");
        if (this.m_gui) {
            configs.add("classpath:/META-INF/opennms/applicationContext-ws-gui.xml");
        }
        this.m_context = new ClassPathXmlApplicationContext(configs.toArray(new String[0]));
        this.m_frontEnd = (PollerFrontEnd)this.m_context.getBean("pollerFrontEnd");
        this.m_frontEnd.addPropertyChangeListener(new PropertyChangeListener(){

            private boolean shouldExit(PropertyChangeEvent e) {
                LogUtils.infof((Object)this, (String)"shouldExit: received property change event: %s;oldvalue:%s;newvalue:%s", (Object[])new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
                String propName = e.getPropertyName();
                Object newValue = e.getNewValue();
                if ("exitNecessary".equals(propName) && Boolean.TRUE.equals(newValue)) {
                    LogUtils.infof((Object)this, (String)"shouldExit: Exiting because exitNecessary is TRUE", (Object[])new Object[0]);
                    return true;
                }
                if ("started".equals(propName) && Boolean.FALSE.equals(newValue)) {
                    LogUtils.infof((Object)this, (String)"shouldExit: Exiting because started is now false", (Object[])new Object[0]);
                    return true;
                }
                LogUtils.infof((Object)this, (String)"shouldExit: not exiting", (Object[])new Object[0]);
                return false;
            }

            public void propertyChange(PropertyChangeEvent e) {
                if (!Main.this.m_shuttingDown && this.shouldExit(e)) {
                    System.exit(10);
                }
            }
        });
    }

    public static void main(String[] args) throws Exception {
        String killSwitchFileName = System.getProperty("opennms.poller.killSwitch.resource");
        File killSwitch = null;
        if (!"".equals(killSwitchFileName) && killSwitchFileName != null && !(killSwitch = new File(System.getProperty("opennms.poller.killSwitch.resource"))).exists()) {
            try {
                killSwitch.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        new Main(args).run();
    }
}

