/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.annotations.Require;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConversionNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePolicy<T> {
    private Match m_match = Match.ANY_PARAMETER;
    private final LinkedHashMap<String, String> m_criteria = new LinkedHashMap();

    protected boolean match(String s, String matcher) {
        if (s == null) {
            return false;
        }
        if (matcher.startsWith("~")) {
            return s.matches(matcher.replaceFirst("~", ""));
        }
        return s.equals(matcher);
    }

    @Require(value={"ANY_PARAMETER", "ALL_PARAMETERS", "NO_PARAMETERS"})
    public String getMatchBehavior() {
        return this.getMatch().toString();
    }

    public void setMatchBehavior(String matchBehavior) {
        String upperMatchBehavior = matchBehavior.toUpperCase();
        if (matchBehavior != null && upperMatchBehavior.contains("ALL")) {
            this.setMatch(Match.ALL_PARAMETERS);
        } else if (matchBehavior != null && upperMatchBehavior.contains("NO")) {
            this.setMatch(Match.NO_PARAMETERS);
        } else {
            this.setMatch(Match.ANY_PARAMETER);
        }
    }

    protected void setMatch(Match match) {
        this.m_match = match;
    }

    protected Match getMatch() {
        return this.m_match;
    }

    protected String getCriteria(String key) {
        return this.getCriteria().get(key);
    }

    protected String putCriteria(String key, String expression) {
        return this.getCriteria().put(key, expression);
    }

    protected LinkedHashMap<String, String> getCriteria() {
        return this.m_criteria;
    }

    protected boolean matches(T iface) {
        switch (this.getMatch()) {
            case ALL_PARAMETERS: {
                return this.matchAll(iface);
            }
            case NO_PARAMETERS: {
                return this.matchNone(iface);
            }
        }
        return this.matchAny(iface);
    }

    private boolean matchAll(T iface) {
        BeanWrapperImpl bean = new BeanWrapperImpl(iface);
        for (Map.Entry<String, String> term : this.getCriteria().entrySet()) {
            String matchExpression;
            String val = BasePolicy.getPropertyValueAsString((BeanWrapper)bean, term.getKey());
            if (this.match(val, matchExpression = term.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean matchAny(T iface) {
        BeanWrapperImpl bean = new BeanWrapperImpl(iface);
        for (Map.Entry<String, String> term : this.getCriteria().entrySet()) {
            String matchExpression;
            String val = BasePolicy.getPropertyValueAsString((BeanWrapper)bean, term.getKey());
            if (!this.match(val, matchExpression = term.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean matchNone(T iface) {
        return !this.matchAny(iface);
    }

    private static String getPropertyValueAsString(BeanWrapper bean, String propertyName) {
        Object value = null;
        try {
            value = bean.getPropertyValue(propertyName);
        }
        catch (BeansException e) {
            ThreadCategory.getInstance(BasePolicy.class).warn("Could not find property \"" + propertyName + "\" on object of type " + bean.getWrappedClass().getName() + ", returning null", (Throwable)e);
            return null;
        }
        try {
            return (String)bean.convertIfNecessary(value, String.class);
        }
        catch (ConversionNotSupportedException e) {
            if (value instanceof InetAddress) {
                return InetAddressUtils.toIpAddrString((byte[])((InetAddress)value).getAddress());
            }
            throw e;
        }
    }

    public abstract T act(T var1);

    public T apply(T iface) {
        if (iface == null) {
            return null;
        }
        if (this.matches(iface)) {
            LogUtils.debugf((Object)this, (String)"Found Match %s for %s", (Object[])new Object[]{iface, this});
            return this.act(iface);
        }
        LogUtils.debugf((Object)this, (String)"No Match Found: %s for %s", (Object[])new Object[]{iface, this});
        return iface;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Match {
        ANY_PARAMETER,
        ALL_PARAMETERS,
        NO_PARAMETERS;

    }
}

