/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.joesnmp;

import java.net.InetAddress;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TrapIdentity;
import org.opennms.netmgt.snmp.TrapInformation;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpValue;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpVarBind;

public class V2TrapInformation
extends TrapInformation {
    private SnmpPduPacket m_pdu;
    static final int SNMP_SYSUPTIME_OID_INDEX = 0;
    static final int SNMP_TRAP_OID_INDEX = 1;
    static final String SNMP_SYSUPTIME_OID = ".1.3.6.1.2.1.1.3.0";
    static final String EXTREME_SNMP_SYSUPTIME_OID = ".1.3.6.1.2.1.1.3";
    static final String SNMP_TRAP_OID = ".1.3.6.1.6.3.1.1.4.1.0";

    public V2TrapInformation(InetAddress agent, String community, SnmpPduPacket pdu, TrapProcessor trapProcessor) {
        super(agent, community, trapProcessor);
        this.m_pdu = pdu;
    }

    private SnmpPduPacket getPdu() {
        return this.m_pdu;
    }

    protected int getPduLength() {
        return this.getPdu().getLength();
    }

    protected long getTimeStamp() {
        if (this.log().isDebugEnabled()) {
            this.log().debug("V2 trap first varbind value: " + this.getPdu().getVarBindAt(0).getValue().toString());
        }
        switch (this.getPdu().getVarBindAt(0).getValue().typeId()) {
            case 67: {
                this.log().debug("V2 trap first varbind value is of type TIMETICKS (correct)");
                return ((SnmpTimeTicks)this.getPdu().getVarBindAt(0).getValue()).getValue();
            }
            case 2: {
                this.log().debug("V2 trap first varbind value is of type INTEGER, casting to TIMETICKS");
                return ((SnmpInt32)this.getPdu().getVarBindAt(0).getValue()).getValue();
            }
        }
        throw new IllegalArgumentException("V2 trap does not have the required first varbind as TIMETICKS - cannot process trap");
    }

    protected TrapIdentity getTrapIdentity() {
        SnmpObjectId snmpTrapOid = (SnmpObjectId)this.getPdu().getVarBindAt(1).getValue();
        SnmpObjectId lastVarBindOid = this.getPdu().getVarBindAt(this.getPduLength() - 1).getName();
        SnmpSyntax lastVarBindValue = this.getPdu().getVarBindAt(this.getPduLength() - 1).getValue();
        return new TrapIdentity(SnmpObjId.get((int[])snmpTrapOid.getIdentifiers()), SnmpObjId.get((int[])lastVarBindOid.getIdentifiers()), (SnmpValue)new JoeSnmpValue(lastVarBindValue));
    }

    public InetAddress getTrapAddress() {
        return this.getAgentAddress();
    }

    protected SnmpVarBind getVarBindAt(int index) {
        return this.getPdu().getVarBindAt(index);
    }

    protected String getVersion() {
        return "v2";
    }

    protected void validate() {
        if (this.getPdu().typeId() != -89) {
            throw new IllegalArgumentException("Received not SNMPv2 Trap from host " + this.getTrapAddress() + "PDU Type = " + this.getPdu().getCommand());
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("V2 trap numVars or pdu length: " + this.getPduLength());
        }
        if (this.getPduLength() < 2) {
            throw new IllegalArgumentException("V2 trap from " + this.getTrapAddress() + " IGNORED due to not having the required varbinds.  Have " + this.getPduLength() + ", needed 2");
        }
        String varBindName0 = this.getPdu().getVarBindAt(0).getName().toString();
        String varBindName1 = this.getPdu().getVarBindAt(1).getName().toString();
        if (varBindName0.equals(EXTREME_SNMP_SYSUPTIME_OID)) {
            this.log().info("V2 trap from " + this.getTrapAddress() + " has been corrected due to the sysUptime.0 varbind not having been sent with a trailing 0.\n\tVarbinds received are : " + varBindName0 + " and " + varBindName1);
            varBindName0 = SNMP_SYSUPTIME_OID;
        }
        if (!varBindName0.equals(SNMP_SYSUPTIME_OID) || !varBindName1.equals(SNMP_TRAP_OID)) {
            throw new IllegalArgumentException("V2 trap from " + this.getTrapAddress() + " IGNORED due to not having the required varbinds.\n\tThe first varbind must be sysUpTime.0 and the second snmpTrapOID.0\n\tVarbinds received are : " + varBindName0 + " and " + varBindName1);
        }
    }

    protected void processVarBindAt(int i) {
        if (i < 2) {
            if (i == 0) {
                this.log().debug("Skipping processing of varbind it is the sysuptime and the first varbind, it is not processed as a parm per RFC2089");
            } else {
                this.log().debug("Skipping processing of varbind it is the trap OID and the second varbind, it is not processed as a parm per RFC2089");
            }
        } else {
            SnmpObjId name = SnmpObjId.get((int[])this.getVarBindAt(i).getName().getIdentifiers());
            JoeSnmpValue value = new JoeSnmpValue(this.getVarBindAt(i).getValue());
            this.processVarBind(name, value);
        }
    }
}

