/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.Security;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.management.MBeanServer;
import mx4j.log.Log;
import mx4j.log.Log4JLogger;
import mx4j.log.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.types.InvokeAtType;
import org.opennms.netmgt.vmmgr.Invoker;
import org.opennms.netmgt.vmmgr.InvokerResult;
import org.opennms.netmgt.vmmgr.InvokerService;
import org.opennms.netmgt.vmmgr.Manager;

public class Starter {
    private static final String LOG4J_CATEGORY = "OpenNMS.Manager";

    private void setLogPrefix() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void startDaemon() {
        this.configureLog4j();
        this.setLogPrefix();
        this.setupMx4jLogger();
        this.loadGlobalProperties();
        this.setDefaultProperties();
        this.start();
    }

    private void setupMx4jLogger() {
        Log.redirectTo((Logger)new Log4JLogger());
    }

    private void configureLog4j() {
        File homeDir = new File(System.getProperty("opennms.home"));
        File etcDir = new File(homeDir, "etc");
        File xmlFile = new File(etcDir, "log4j.xml");
        if (xmlFile.exists()) {
            DOMConfigurator.configureAndWatch((String)xmlFile.getAbsolutePath());
        } else {
            File propertiesFile = new File(etcDir, "log4j.properties");
            if (propertiesFile.exists()) {
                PropertyConfigurator.configureAndWatch((String)propertiesFile.getAbsolutePath());
            } else {
                this.die("Could not find a Log4j configuration file at " + xmlFile.getAbsolutePath() + " or " + propertiesFile.getAbsolutePath() + ".  Exiting.");
            }
        }
    }

    private void setDefaultProperties() {
        this.setupFileResourceProperty("opennms.library.jicmp", System.mapLibraryName("jicmp"), "Initialization of ICMP socket will likely fail.");
        this.setupFileResourceProperty("opennms.library.jrrd", System.mapLibraryName("jrrd"), "Initialization of RRD code will likely fail if the JniRrdStrategy is used.");
        this.setupFileResourceProperty("jcifs.properties", "jcifs.properties", "Initialization of JCIFS will likely fail or may be improperly configured.");
    }

    private void setupFileResourceProperty(String propertyName, String file, String notFoundWarning) {
        if (System.getProperty(propertyName) == null) {
            this.log().debug("System property '" + propertyName + "' not set.  Searching for file '" + file + "' in the class path.");
            URL url = this.getClass().getClassLoader().getResource(file);
            if (url != null) {
                this.log().info("Found file '" + file + "' at '" + url.getPath() + "'.  Setting '" + propertyName + "' to this path.");
                System.setProperty(propertyName, url.getPath());
            } else {
                this.log().warn("Did not find file '" + file + "' in the class path.  " + notFoundWarning + "  Set the property '" + propertyName + "' to the location of the file.");
            }
        } else {
            this.log().info("System property '" + propertyName + "' already set to '" + System.getProperty(propertyName) + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGlobalProperties() {
        TreeMap<Object, Object> sortedProps = new TreeMap<Object, Object>(System.getProperties());
        for (Map.Entry<Object, Object> entry : sortedProps.entrySet()) {
            this.log().info("System property '" + entry.getKey() + "' already set to value '" + entry.getValue() + "'.");
        }
        File propertiesFile = this.getPropertiesFile();
        if (!propertiesFile.exists()) {
            return;
        }
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertiesFile);
            props.load(in);
        }
        catch (IOException e) {
            try {
                this.die("Error trying to read properties file '" + propertiesFile + "': " + e, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((InputStream)in);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String systemValue = System.getProperty(entry.getKey().toString());
            if (systemValue != null) {
                this.log().info("Property '" + entry.getKey() + "' from " + propertiesFile + " already exists as a system property (with value '" + systemValue + "').  Not overridding existing system property.");
                continue;
            }
            this.log().info("Setting system property '" + entry.getKey() + "' to '" + entry.getValue() + "' from " + propertiesFile + ".");
            System.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        if (props.containsKey("networkaddress.cache.ttl")) {
            Security.setProperty("networkaddress.cache.ttl", props.getProperty("networkaddress.cache.ttl"));
        } else {
            Security.setProperty("networkaddress.cache.ttl", "120");
        }
    }

    private void die(String message, Throwable t) {
        LogUtils.errorf((Object)this, (Throwable)t, (String)message, (Object[])new Object[0]);
        System.exit(1);
    }

    private void die(String message) {
        this.die(message, null);
    }

    private File getPropertiesFile() {
        String homeDir = System.getProperty("opennms.home");
        File etcDir = new File(homeDir, "etc");
        File propertiesFile = new File(etcDir, "opennms.properties");
        return propertiesFile;
    }

    private void start() {
        this.log().debug("Beginning startup");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Invoker invoker = new Invoker();
        invoker.setServer(server);
        invoker.setAtType(InvokeAtType.START);
        List<InvokerService> services = InvokerService.createServiceList(Invoker.getDefaultServiceConfigFactory().getServices());
        invoker.setServices(services);
        invoker.instantiateClasses();
        List<InvokerResult> resultInfo = invoker.invokeMethods();
        for (InvokerResult result : resultInfo) {
            if (result == null || result.getThrowable() == null) continue;
            Service service = result.getService();
            String name = service.getName();
            String className = service.getClassName();
            String message = "An error occurred while attempting to start the \"" + name + "\" service (class " + className + ").  " + "Shutting down and exiting.";
            this.log().fatal(message, result.getThrowable());
            System.err.println(message);
            result.getThrowable().printStackTrace();
            Manager manager = new Manager();
            manager.stop();
            manager.doSystemExit();
            return;
        }
        this.log().debug("Startup complete");
    }
}

