/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.File;
import java.rmi.ConnectException;
import java.util.Map;
import org.opennms.netmgt.Registry;
import org.opennms.netmgt.vmmgr.DaemonManager;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringLoader {
    private ApplicationContext m_appContext;

    public SpringLoader(String operation) throws Throwable {
        String startupUrl = this.getStartupResource();
        String[] paths = new String[]{"classpath:/org/opennms/netmgt/vmmgr/remote-access.xml"};
        if ("start".equals(operation)) {
            paths = new String[]{startupUrl, "classpath:/org/opennms/netmgt/vmmgr/local-access.xml", "classpath*:/META-INF/opennms/context.xml"};
        }
        try {
            ClassPathXmlApplicationContext classPathXmlApplicationContext = new ClassPathXmlApplicationContext(paths);
            classPathXmlApplicationContext.registerShutdownHook();
            this.m_appContext = classPathXmlApplicationContext;
        }
        catch (BeanCreationException e) {
            e.printStackTrace();
            Throwable rc = e.getRootCause();
            System.err.println("ROOT CAUSE is " + rc);
            if (rc == null) {
                throw e;
            }
            throw rc;
        }
        Registry.setAppContext(this.m_appContext);
    }

    private String getStartupResource() {
        File startupFile;
        String startupUrl = System.getProperty("opennms.startup.context");
        if (startupUrl != null) {
            return startupUrl;
        }
        String etcDir = this.getEtcDir();
        if (etcDir != null && (startupFile = new File(etcDir, "startup.xml")).exists()) {
            return startupFile.toURI().toString();
        }
        return "classpath:/META-INF/opennms/default-startup.xml";
    }

    private String getEtcDir() {
        String etcDir = System.getProperty("opennms.etc");
        if (etcDir != null) {
            return etcDir;
        }
        String homeDir = System.getProperty("opennms.home");
        if (homeDir != null) {
            return homeDir + File.separator + "etc";
        }
        return null;
    }

    public void start() throws Throwable {
        this.getDaemonMgr().start();
    }

    private DaemonManager getDaemonMgr() throws Throwable {
        try {
            return (DaemonManager)this.m_appContext.getBean("daemonMgr");
        }
        catch (BeanCreationException e) {
            Throwable rc = e.getRootCause();
            System.err.println("ROOT CAUSE is " + rc);
            throw rc;
        }
    }

    private void stop() throws Throwable {
        this.getDaemonMgr().stop();
    }

    private void pause() throws Throwable {
        this.getDaemonMgr().pause();
    }

    private void resume() throws Throwable {
        this.getDaemonMgr().resume();
    }

    private void status() throws Throwable {
        Map<String, String> stati = this.getDaemonMgr().status();
        for (Map.Entry<String, String> entry : stati.entrySet()) {
            System.err.println(entry.getKey() + ": " + entry.getValue());
        }
    }

    public static void main(String[] args) {
        try {
            String cmd = args[0];
            if ("-u".equals(cmd)) {
                cmd = args[2];
            }
            SpringLoader loader = new SpringLoader(cmd);
            if ("start".equals(cmd)) {
                loader.start();
            } else if ("stop".equals(cmd)) {
                loader.stop();
            } else if ("pause".equals(cmd)) {
                loader.pause();
            } else if ("resume".equals(cmd)) {
                loader.resume();
            } else if ("status".equals(cmd)) {
                loader.status();
            } else {
                SpringLoader.usage();
            }
        }
        catch (ConnectException e) {
            System.err.println("opennms is not running.");
            System.exit(3);
        }
        catch (Throwable e) {
            System.err.println("Exception occurred: " + e);
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void usage() {
        System.err.println("opennms.sh [start|pause|resume|stop|status]");
        System.exit(1);
    }
}

