/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import org.apache.log4j.PropertyConfigurator;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ServiceConfigFactory;
import org.opennms.netmgt.config.service.Argument;
import org.opennms.netmgt.config.service.Attribute;
import org.opennms.netmgt.config.service.Invoke;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.vmmgr.DatabaseChecker;
import org.opennms.netmgt.vmmgr.Starter;
import org.opennms.netmgt.vmmgr.StatusGetter;

public class Controller {
    private static final String JMX_HTTP_ADAPTER_NAME = ":Name=HttpAdaptorMgmt";
    public static final String DEFAULT_INVOKER_URL = "http://127.0.0.1:8181/invoke?objectname=OpenNMS%3AName=Manager";
    private static final String LOG4J_CATEGORY = "OpenNMS.Manager";
    private static final int DEFAULT_HTTP_REQUEST_READ_TIMEOUT = 0;
    private boolean m_verbose = false;
    private String m_invokeUrl = "http://127.0.0.1:8181/invoke?objectname=OpenNMS%3AName=Manager";
    private Authenticator m_authenticator;
    private int m_httpRequestReadTimeout = 0;

    public static void main(String[] argv) {
        Controller.configureLog4j();
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Controller c = new Controller();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-h")) {
                System.out.println("Usage: java org.opennms.netmgt.vmmgr.Controller [<options>] <command>");
                System.out.println("Accepted options:");
                System.out.println("        -t <timeout>    HTTP connection timeout in seconds.  Defaults to 30.");
                System.out.println("        -u <URL>        Alternate invoker URL.");
                System.out.println("        -v              Verbose mode.");
                System.out.println("");
                System.out.println("Accepted commands: start, stop, status");
                System.out.println("");
                System.out.println("The default invoker URL is: http://127.0.0.1:8181/invoke?objectname=OpenNMS%3AName=Manager");
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-t")) {
                c.setHttpRequestReadTimeout(Integer.parseInt(argv[i + 1]) * 1000);
                ++i;
                continue;
            }
            if (argv[i].equals("-v")) {
                c.setVerbose(true);
                continue;
            }
            if (argv[i].equals("-u")) {
                c.setInvokeUrl(argv[i + 1]);
                ++i;
                continue;
            }
            if (i == argv.length - 1) break;
            System.err.println("Invalid command-line option: \"" + argv[i] + "\".  Use \"-h\" option for help.");
            System.exit(1);
        }
        if (argv.length == 0) {
            System.err.println("You must specify a command.  Use \"-h\" option for help");
            System.exit(1);
        }
        c.setAuthenticator(c.createAuthenticatorUsingConfigCredentials());
        String command = argv[argv.length - 1];
        if ("start".equals(command)) {
            c.start();
        } else if ("stop".equals(command)) {
            System.exit(c.stop());
        } else if ("status".equals(command)) {
            System.exit(c.status());
        } else if ("check".equals(command)) {
            System.exit(c.check());
        } else if ("exit".equals(command)) {
            System.exit(c.exit());
        } else {
            System.err.println("Invalid command \"" + command + "\".");
            System.err.println("Use \"-h\" option for help.");
            System.exit(1);
        }
    }

    private static void configureLog4j() {
        File homeDir = new File(System.getProperty("opennms.home"));
        File etcDir = new File(homeDir, "etc");
        File controllerProperties = new File(etcDir, "log4j-controller.properties");
        PropertyConfigurator.configure((String)controllerProperties.getAbsolutePath());
    }

    public void start() {
        Starter starter = new Starter();
        starter.startDaemon();
    }

    public int stop() {
        return this.invokeOperation("stop");
    }

    public int status() {
        String message;
        Authenticator.setDefault(this.getAuthenticator());
        StatusGetter statusGetter = new StatusGetter();
        statusGetter.setVerbose(this.isVerbose());
        String url = this.getInvokeUrl() + "&operation=status";
        try {
            statusGetter.setInvokeURL(new URL(url));
        }
        catch (MalformedURLException e) {
            message = "Error creating URL object for invoke URL: '" + url + "'";
            System.err.println(message);
            LogUtils.errorf((Object)this, (Throwable)e, (String)message, (Object[])new Object[0]);
        }
        try {
            statusGetter.queryStatus();
        }
        catch (Throwable t) {
            message = "Error invoking status command";
            System.err.println(message);
            LogUtils.errorf((Object)this, (Throwable)t, (String)message, (Object[])new Object[0]);
            return 1;
        }
        switch (statusGetter.getStatus()) {
            case NOT_RUNNING: 
            case CONNECTION_REFUSED: {
                return 3;
            }
            case PARTIALLY_RUNNING: {
                return 160;
            }
            case RUNNING: {
                return 0;
            }
        }
        LogUtils.errorf((Object)this, (String)"Unknown status returned from statusGetter.getStatus(): %s", (Object[])new Object[]{statusGetter.getStatus()});
        return 1;
    }

    public int check() {
        try {
            new DatabaseChecker().check();
        }
        catch (Throwable t) {
            LogUtils.errorf((Object)this, (Throwable)t, (String)"error invoking check command", (Object[])new Object[0]);
            return 1;
        }
        return 0;
    }

    public int exit() {
        return this.invokeOperation("doSystemExit");
    }

    int invokeOperation(String operation) {
        Authenticator.setDefault(this.getAuthenticator());
        String urlString = this.getInvokeUrl() + "&operation=" + operation;
        try {
            int ch;
            URL invoke = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)invoke.openConnection();
            connection.setReadTimeout(this.getHttpRequestReadTimeout());
            InputStream in = connection.getInputStream();
            while ((ch = in.read()) != -1) {
                System.out.write((char)ch);
            }
            in.close();
            System.out.println("");
            System.out.flush();
        }
        catch (ConnectException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"error when attempting to fetch URL \"%s\"", (Object[])new Object[]{urlString});
            if (this.isVerbose()) {
                System.out.println(e.getMessage() + " when attempting to fetch URL \"" + urlString + "\"");
            }
            return 1;
        }
        catch (Throwable t) {
            LogUtils.errorf((Object)this, (Throwable)t, (String)"error invoking %s operation", (Object[])new Object[]{operation});
            System.out.println("error invoking " + operation + " operation");
            return 1;
        }
        return 0;
    }

    Authenticator createAuthenticatorUsingConfigCredentials() {
        Service service = this.getConfiguredService(JMX_HTTP_ADAPTER_NAME);
        if (service == null) {
            LogUtils.warnf((Object)this, (String)"Could not find configured service for '%s'", (Object[])new Object[]{JMX_HTTP_ADAPTER_NAME});
            return null;
        }
        Attribute[] attribs = service.getAttribute();
        if (attribs == null) {
            return null;
        }
        boolean usingBasic = false;
        for (Attribute attrib : attribs) {
            if (!attrib.getName().equals("AuthenticationMethod")) continue;
            if (!attrib.getValue().getContent().equals("basic")) {
                LogUtils.errorf((Object)this, (String)"AuthenticationMethod is \"%s\", but only \"basic\" is supported", (Object[])new Object[]{attrib.getValue()});
                return null;
            }
            usingBasic = true;
            break;
        }
        if (!usingBasic) {
            return null;
        }
        Invoke[] invokes = service.getInvoke();
        if (invokes == null) {
            return null;
        }
        String username = null;
        String password = null;
        for (Invoke invoke : invokes) {
            Argument[] args;
            if (!invoke.getMethod().equals("addAuthorization") || (args = invoke.getArgument()) == null || args.length != 2 || !args[0].getContent().equals("manager")) continue;
            username = args[0].getContent();
            password = args[1].getContent();
            break;
        }
        if (username == null || password == null) {
            return null;
        }
        final String username_f = username;
        final String password_f = password;
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username_f, password_f.toCharArray());
            }
        };
    }

    private ServiceConfigFactory getServiceConfigFactory() {
        try {
            ServiceConfigFactory.init();
            return ServiceConfigFactory.getInstance();
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    private Service getConfiguredService(String serviceName) {
        Service[] services;
        ServiceConfigFactory sfact = this.getServiceConfigFactory();
        for (Service service : services = sfact.getServices()) {
            if (!service.getName().equals(serviceName)) continue;
            return service;
        }
        return null;
    }

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public String getInvokeUrl() {
        return this.m_invokeUrl;
    }

    public void setInvokeUrl(String invokerUrl) {
        this.m_invokeUrl = invokerUrl;
    }

    public Authenticator getAuthenticator() {
        return this.m_authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.m_authenticator = authenticator;
    }

    public int getHttpRequestReadTimeout() {
        return this.m_httpRequestReadTimeout;
    }

    public void setHttpRequestReadTimeout(int httpRequestReadTimeout) {
        this.m_httpRequestReadTimeout = httpRequestReadTimeout;
    }
}

