/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import net.jradius.exception.RadiusException;
import net.jradius.handler.chain.JRCommand;
import net.jradius.log.RadiusLog;
import net.jradius.server.EventDispatcher;
import net.jradius.server.JRadiusThread;
import net.jradius.server.ListenerRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Processor
extends JRadiusThread
implements ApplicationContextAware {
    protected ApplicationContext applicationContext;
    private EventDispatcher eventDispatcher;
    private List<JRCommand> requestHandlers;
    private BlockingQueue<ListenerRequest> queue;
    private boolean active = true;

    public void setRequestQueue(BlockingQueue<ListenerRequest> q) {
        this.queue = q;
    }

    public BlockingQueue getRequestQueue() {
        return this.queue;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public void setRequestHandlers(List<JRCommand> handlers) {
        this.requestHandlers = handlers;
    }

    public List<JRCommand> getRequestHandlers() {
        return this.requestHandlers;
    }

    protected abstract void processRequest(ListenerRequest var1) throws IOException, RadiusException;

    @Override
    public void run() {
        while (this.isActive()) {
            try {
                Thread.yield();
                this.process();
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                System.err.println(this.getName() + ": process() method threw an exception: " + e);
                RadiusLog.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void process() throws Exception, InterruptedException {
        Object queueElement = this.getRequestQueue().take();
        if (!(queueElement instanceof ListenerRequest)) {
            throw new IllegalArgumentException("Expected ListenerRequest but found " + queueElement.getClass().getName());
        }
        this.processRequest((ListenerRequest)queueElement);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            this.interrupt();
        }
    }
}

