/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jradius.packet.Format;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.VSAttribute;
import net.jradius.packet.attribute.value.AttributeValue;

public class DiameterFormat
extends Format {
    private static final byte AVP_VENDOR = -128;

    public void packAttribute(OutputStream out, RadiusAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        int length = attributeValue.getLength();
        int padding = (length + 3 & 0xFFFFFFFC) - length;
        if (a instanceof VSAttribute) {
            this.packHeader(out, (VSAttribute)a);
        } else {
            this.formatHeader(out, a);
        }
        attributeValue.getBytes(out);
        while (padding-- > 0) {
            out.write(0);
        }
    }

    private void formatHeader(OutputStream out, RadiusAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        DiameterFormat.writeUnsignedInt(out, a.getType());
        DiameterFormat.writeUnsignedByte(out, 0);
        DiameterFormat.writeUnsignedByte(out, 0);
        DiameterFormat.writeUnsignedShort(out, attributeValue.getLength() + 8);
    }

    public void packHeader(OutputStream out, RadiusAttribute a) throws IOException {
        if (a instanceof VSAttribute) {
            this.packHeader(out, (VSAttribute)a);
        }
    }

    public void packHeader(OutputStream out, VSAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        DiameterFormat.writeUnsignedInt(out, a.getVsaAttributeType());
        DiameterFormat.writeUnsignedByte(out, -128);
        DiameterFormat.writeUnsignedByte(out, 0);
        DiameterFormat.writeUnsignedShort(out, attributeValue.getLength() + 12);
        DiameterFormat.writeUnsignedInt(out, a.getVendorId());
    }

    public int unpackAttributeHeader(InputStream in, Format.AttributeParseContext ctx) throws IOException {
        ctx.attributeType = (int)DiameterFormat.readUnsignedInt(in);
        long flen = DiameterFormat.readUnsignedInt(in);
        byte flags = (byte)(flen >> 24 & 0xFFL);
        ctx.attributeLength = (int)(flen & 0xFFFFFFL);
        ctx.headerLength = 8;
        if ((flags & 0xFFFFFF80) > 0) {
            ctx.vendorNumber = (int)DiameterFormat.readUnsignedInt(in);
            ctx.headerLength += 4;
        }
        ctx.padding = (ctx.attributeLength + 3 & 0xFFFFFFFC) - ctx.attributeLength;
        return 0;
    }
}

