/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.freeradius;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jradius.packet.Format;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.value.AttributeValue;

public class FreeRadiusFormat
extends RadiusFormat {
    private static final FreeRadiusFormat staticFormat = new FreeRadiusFormat();

    public static void setAttributeBytes(RadiusPacket p, byte[] bAttributes) {
        int attributesLength = bAttributes.length;
        if (attributesLength > 0) {
            staticFormat.unpackAttributes(p.getAttributes(), bAttributes, 0, attributesLength);
        }
    }

    public void packHeader(OutputStream out, RadiusPacket p, byte[] attributeBytes, String sharedSecret) throws IOException {
        FreeRadiusFormat.writeUnsignedInt(out, p.getCode());
        FreeRadiusFormat.writeUnsignedInt(out, p.getIdentifier());
        FreeRadiusFormat.writeUnsignedInt(out, attributeBytes == null ? 0L : (long)attributeBytes.length);
    }

    public void packHeader(OutputStream out, RadiusAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        FreeRadiusFormat.writeUnsignedInt(out, a.getFormattedType());
        FreeRadiusFormat.writeUnsignedInt(out, attributeValue.getLength());
        FreeRadiusFormat.writeUnsignedInt(out, a.getAttributeOp());
    }

    public int unpackAttributeHeader(InputStream in, Format.AttributeParseContext ctx) throws IOException {
        ctx.attributeType = (int)FreeRadiusFormat.readUnsignedInt(in);
        ctx.attributeLength = (int)FreeRadiusFormat.readUnsignedInt(in);
        ctx.attributeOp = (int)FreeRadiusFormat.readUnsignedInt(in);
        if (ctx.attributeType > 65536) {
            ctx.vendorNumber = ctx.attributeType >> 16 & 0xFFFF;
            ctx.attributeType &= 0xFFFF;
        }
        return 12;
    }
}

