/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.util.ArrayList;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpUInt32;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.SnmpVarBind;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpPduTrap
implements SnmpSyntax,
Cloneable {
    private SnmpObjectId m_enterprise;
    private SnmpIPAddress m_agentAddr;
    private int m_generic;
    private int m_specific;
    private long m_tstamp;
    private ArrayList<SnmpVarBind> m_variables;
    public static final int TRAP = 164;
    public static final int GenericColdStart = 0;
    public static final int GenericWarmStart = 1;
    public static final int GenericLinkDown = 2;
    public static final int GenericLinkUp = 3;
    public static final int GenericAuthenticationFailure = 4;
    public static final int GenericEgpNeighborLoss = 5;
    public static final int GenericEnterpriseSpecific = 6;

    public SnmpPduTrap() {
        this.m_enterprise = new SnmpObjectId();
        this.m_agentAddr = new SnmpIPAddress();
        this.m_generic = 0;
        this.m_specific = 0;
        this.m_tstamp = 0L;
        this.m_variables = new ArrayList();
    }

    protected SnmpPduTrap(SnmpPduTrap second) {
        this.m_enterprise = second.m_enterprise;
        this.m_agentAddr = second.m_agentAddr;
        this.m_generic = second.m_generic;
        this.m_specific = second.m_specific;
        this.m_tstamp = second.m_tstamp;
        this.m_variables = new ArrayList(second.m_variables.size());
        for (int x = 0; x < second.m_variables.size(); ++x) {
            this.m_variables.add(second.m_variables.get(x).duplicate());
        }
    }

    public SnmpObjectId getEnterprise() {
        return this.m_enterprise;
    }

    public void setEnterprise(SnmpObjectId id) {
        this.m_enterprise = (SnmpObjectId)id.clone();
    }

    public void setEnterprise(String id) {
        this.m_enterprise = new SnmpObjectId(id);
    }

    public SnmpIPAddress getAgentAddress() {
        return this.m_agentAddr;
    }

    public void setAgentAddress(SnmpIPAddress addr) {
        this.m_agentAddr = addr;
    }

    public int getGeneric() {
        return this.m_generic;
    }

    public void setGeneric(int generic) {
        this.m_generic = generic;
    }

    public int getSpecific() {
        return this.m_specific;
    }

    public void setSpecific(int spec) {
        this.m_specific = spec;
    }

    public long getTimeStamp() {
        return this.m_tstamp;
    }

    public void setTimeStamp(long ts) {
        this.m_tstamp = ts;
    }

    public int getLength() {
        return this.m_variables.size();
    }

    public void addVarBind(SnmpVarBind vb) {
        this.m_variables.add(vb);
    }

    public void addVarBindAt(int ndx, SnmpVarBind vb) {
        this.m_variables.add(ndx, vb);
    }

    public SnmpVarBind getVarBindAt(int ndx) {
        return this.m_variables.get(ndx);
    }

    public void setVarBindAt(int ndx, SnmpVarBind vb) {
        this.m_variables.set(ndx, vb);
    }

    public SnmpVarBind removeVarBindAt(int ndx) {
        return this.m_variables.remove(ndx);
    }

    public SnmpVarBind[] toVarBindArray() {
        return this.m_variables.toArray(new SnmpVarBind[this.m_variables.size()]);
    }

    public byte typeId() {
        return -92;
    }

    public int encodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnEncodingException {
        int begin = offset;
        offset = this.m_enterprise.encodeASN(buf, offset, encoder);
        offset = this.m_agentAddr.encodeASN(buf, offset, encoder);
        SnmpSyntax val = new SnmpInt32(this.m_generic);
        offset = ((SnmpInt32)val).encodeASN(buf, offset, encoder);
        ((SnmpInt32)val).setValue(this.m_specific);
        offset = ((SnmpInt32)val).encodeASN(buf, offset, encoder);
        val = new SnmpTimeTicks(this.m_tstamp);
        int vbbegin = offset = ((SnmpUInt32)val).encodeASN(buf, offset, encoder);
        int sz = this.m_variables.size();
        for (int x = 0; x < sz; ++x) {
            SnmpVarBind ref = this.m_variables.get(x);
            offset = ref.encodeASN(buf, offset, encoder);
        }
        int pivot = offset;
        offset = encoder.buildHeader(buf, offset, (byte)48, pivot - vbbegin);
        SnmpUtil.rotate(buf, vbbegin, pivot, offset);
        pivot = offset;
        offset = encoder.buildHeader(buf, offset, this.typeId(), pivot - begin);
        SnmpUtil.rotate(buf, begin, pivot, offset);
        return offset;
    }

    public int decodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnDecodingException {
        Object[] rVals = encoder.parseHeader(buf, offset);
        offset = (Integer)rVals[0];
        int cmd = ((Byte)rVals[1]).intValue();
        int length = (Integer)rVals[2];
        int begin = offset;
        if (cmd < 0) {
            cmd += 256;
        }
        if (164 != cmd) {
            throw new AsnDecodingException("Invalid SNMP command, Not a Trap");
        }
        offset = this.m_enterprise.decodeASN(buf, offset, encoder);
        offset = this.m_agentAddr.decodeASN(buf, offset, encoder);
        SnmpSyntax val = new SnmpInt32();
        offset = ((SnmpInt32)val).decodeASN(buf, offset, encoder);
        this.m_generic = ((SnmpInt32)val).getValue();
        offset = ((SnmpInt32)val).decodeASN(buf, offset, encoder);
        this.m_specific = ((SnmpInt32)val).getValue();
        val = new SnmpTimeTicks();
        offset = ((SnmpUInt32)val).decodeASN(buf, offset, encoder);
        this.m_tstamp = ((SnmpUInt32)val).getValue();
        rVals = encoder.parseHeader(buf, offset);
        offset = (Integer)rVals[0];
        byte asnType = (Byte)rVals[1];
        if (asnType != 48) {
            throw new AsnDecodingException("Invalid SNMP variable list");
        }
        begin = offset;
        this.m_variables.clear();
        SnmpVarBind vb = new SnmpVarBind();
        for (length = ((Integer)rVals[2]).intValue(); length > 0; length -= offset - begin) {
            offset = vb.decodeASN(buf, offset, encoder);
            begin = offset;
            this.m_variables.add(vb.duplicate());
        }
        return offset;
    }

    public SnmpSyntax duplicate() {
        return new SnmpPduTrap(this);
    }

    public Object clone() {
        return new SnmpPduTrap(this);
    }
}

