/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IPv4Monitor
implements ServiceMonitor {
    @Override
    public void initialize(Map<String, Object> parameters) {
    }

    @Override
    public void release() {
    }

    @Override
    public void initialize(MonitoredService svc) {
        NetworkInterface iface = svc.getNetInterface();
        if (!(iface.getAddress() instanceof InetAddress)) {
            throw new NetworkInterfaceNotSupportedException("Address type not supported");
        }
    }

    @Override
    public void release(MonitoredService svc) {
    }

    @Override
    public abstract PollStatus poll(MonitoredService var1, Map<String, Object> var2);

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    protected PollStatus logDown(Level level, String reason) {
        return this.logDown(level, reason, null);
    }

    protected PollStatus logDown(Level level, String reason, Throwable e) {
        String className = ClassUtils.getShortName(this.getClass());
        this.log().debug(className + ": " + reason, e);
        return PollStatus.unavailable((String)reason);
    }

    protected PollStatus logUp(Level level, double responseTime, String logMsg) {
        String className = ClassUtils.getShortName(this.getClass());
        this.log().debug(className + ": " + logMsg);
        return PollStatus.available((Double)responseTime);
    }
}

