/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import org.opennms.protocols.icmp.ICMPHeader;
import org.opennms.protocols.ip.OC16ChecksumProducer;

public final class ICMPEchoPacket
extends ICMPHeader {
    private static final byte[] NAMED_PAD = new byte[]{79, 112, 101, 110, 78, 77, 83, 33};
    private long m_sent;
    private long m_recv;
    private long m_tid;
    private byte[] m_pad;
    private long m_rtt;
    private static final int PAD_SIZE = 16;

    private static long byteToLong(byte b) {
        long r = b;
        if (r < 0L) {
            r += 256L;
        }
        return r;
    }

    private ICMPEchoPacket() {
        throw new UnsupportedOperationException("illegal constructor call");
    }

    public ICMPEchoPacket(long tid) {
        super((byte)8, (byte)0);
        int x;
        this.setNextSequenceId();
        this.m_rtt = 0L;
        this.m_sent = 0L;
        this.m_recv = 0L;
        this.m_tid = tid;
        this.m_pad = new byte[16];
        for (x = 0; x < NAMED_PAD.length && x < 16; ++x) {
            this.m_pad[x] = NAMED_PAD[x];
        }
        for (x = NAMED_PAD.length; x < 16; ++x) {
            this.m_pad[x] = (byte)x;
        }
    }

    public ICMPEchoPacket(byte[] buf) {
        this.m_pad = null;
        this.loadFromBuffer(buf, 0);
    }

    public final long getSentTime() {
        return this.m_sent;
    }

    public final long setSentTime() {
        this.m_sent = System.currentTimeMillis();
        return this.m_sent;
    }

    public final void setSentTime(long time) {
        this.m_sent = time;
    }

    public final long getReceivedTime() {
        return this.m_recv;
    }

    public final long setReceivedTime() {
        this.m_recv = System.currentTimeMillis();
        return this.m_recv;
    }

    public final void setReceivedTime(long time) {
        this.m_recv = time;
    }

    public final void setPingRTT(long time) {
        this.m_rtt = time;
    }

    public final long getPingRTT() {
        return this.m_rtt;
    }

    public static final int getNetworkSize() {
        return ICMPHeader.getNetworkSize() + 32 + 16;
    }

    public final void computeChecksum() {
        OC16ChecksumProducer summer = new OC16ChecksumProducer();
        super.computeChecksum(summer);
        summer.add(this.m_rtt);
        summer.add(this.m_sent);
        summer.add(this.m_recv);
        summer.add(this.m_tid);
        int stop = this.m_pad.length - this.m_pad.length % 2;
        for (int i = 0; i < stop; i += 2) {
            summer.add(this.m_pad[i], this.m_pad[i + 1]);
        }
        if (this.m_pad.length % 2 == 1) {
            summer.add(this.m_pad[this.m_pad.length]);
        }
        super.setChecksum(summer.getChecksum());
    }

    public final long getTID() {
        return this.m_tid;
    }

    public final void setTID(long tid) {
        this.m_tid = tid;
    }

    public final int loadFromBuffer(byte[] buf, int offset) {
        int x;
        if (buf.length - offset < ICMPEchoPacket.getNetworkSize()) {
            throw new IndexOutOfBoundsException("Insufficient Data");
        }
        offset = super.loadFromBuffer(buf, offset);
        if (!this.isEchoReply() && !this.isEchoRequest()) {
            throw new IllegalArgumentException("Invalid type, must be echo request/reply packet");
        }
        this.m_sent = 0L;
        for (x = 0; x < 8; ++x) {
            this.m_sent <<= 8;
            this.m_sent |= ICMPEchoPacket.byteToLong(buf[offset++]);
        }
        this.m_recv = 0L;
        for (x = 0; x < 8; ++x) {
            this.m_recv <<= 8;
            this.m_recv |= ICMPEchoPacket.byteToLong(buf[offset++]);
        }
        this.m_tid = 0L;
        for (x = 0; x < 8; ++x) {
            this.m_tid <<= 8;
            this.m_tid |= ICMPEchoPacket.byteToLong(buf[offset++]);
        }
        this.m_rtt = 0L;
        for (x = 0; x < 8; ++x) {
            this.m_rtt <<= 8;
            this.m_rtt |= ICMPEchoPacket.byteToLong(buf[offset++]);
        }
        if (this.m_pad == null) {
            this.m_pad = new byte[16];
        }
        for (x = 0; x < 16; ++x) {
            this.m_pad[x] = buf[offset++];
        }
        return offset;
    }

    public final int storeToBuffer(byte[] buf, int offset) {
        int x;
        if (buf.length - offset < ICMPEchoPacket.getNetworkSize()) {
            throw new IndexOutOfBoundsException("Insufficient Buffer Size");
        }
        offset = super.storeToBuffer(buf, offset);
        long t = this.m_sent;
        for (x = 0; x < 8; ++x) {
            buf[offset++] = (byte)(t >>> 56);
            t <<= 8;
        }
        t = this.m_recv;
        for (x = 0; x < 8; ++x) {
            buf[offset++] = (byte)(t >>> 56);
            t <<= 8;
        }
        t = this.m_tid;
        for (x = 0; x < 8; ++x) {
            buf[offset++] = (byte)(t >>> 56);
            t <<= 8;
        }
        t = this.m_rtt;
        for (x = 0; x < 8; ++x) {
            buf[offset++] = (byte)(t >>> 56);
            t <<= 8;
        }
        for (x = 0; x < 16; ++x) {
            buf[offset++] = this.m_pad[x];
        }
        return offset;
    }

    public final byte[] toBytes() {
        byte[] buf = new byte[ICMPEchoPacket.getNetworkSize()];
        this.storeToBuffer(buf, 0);
        return buf;
    }
}

