/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.support;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opennms.core.soa.Filter;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.RegistrationListener;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.filter.FilterParser;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceListFactoryBean<T>
implements FactoryBean<List<T>>,
InitializingBean,
RegistrationListener<T> {
    private ServiceRegistry m_serviceRegistry;
    private Class<T> m_serviceInterface;
    private List<RegistrationListener<T>> m_listeners = new CopyOnWriteArrayList<RegistrationListener<T>>();
    private List<T> m_providerRegistrations = new CopyOnWriteArrayList<T>();
    private Filter m_filter;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.m_serviceRegistry = serviceRegistry;
    }

    public void setServiceInterface(Class<T> serviceInterface) {
        this.m_serviceInterface = serviceInterface;
    }

    public void setFilter(String filter) {
        this.m_filter = filter == null ? null : new FilterParser().parse(filter);
    }

    public List<T> getObject() throws Exception {
        return this.m_providerRegistrations;
    }

    public Class<?> getObjectType() {
        return List.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_serviceRegistry, (String)"The serviceRegistry must be set");
        Assert.notNull(this.m_serviceInterface, (String)"The serviceInterface must be set");
        this.m_serviceRegistry.addListener(this.m_serviceInterface, this, true);
    }

    @Override
    public void providerRegistered(Registration registration, T provider) {
        if (this.m_filter != null && !this.m_filter.match(registration.getProperties())) {
            return;
        }
        this.m_providerRegistrations.add(provider);
        for (RegistrationListener<T> listener : this.m_listeners) {
            listener.providerRegistered(registration, provider);
        }
    }

    @Override
    public void providerUnregistered(Registration registration, T provider) {
        boolean found = this.m_providerRegistrations.remove(provider);
        if (!found) {
            return;
        }
        for (RegistrationListener<T> listener : this.m_listeners) {
            listener.providerUnregistered(registration, provider);
        }
    }

    public void setListener(RegistrationListener<T> listener) {
        this.addListener(listener);
    }

    public void addListener(RegistrationListener<T> listener) {
        this.m_listeners.add(listener);
    }

    public void removeListener(RegistrationListener<?> listener) {
        this.m_listeners.remove(listener);
    }
}

