/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.discovery;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opennms.netmgt.model.discovery.IPAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPAddressRange
implements Iterable<IPAddress> {
    private final IPAddress m_begin;
    private final IPAddress m_end;

    public IPAddressRange(String begin, String end) {
        this(new IPAddress(begin), new IPAddress(end));
    }

    public IPAddressRange(IPAddress begin, IPAddress end) {
        if (begin.isGreaterThan(end)) {
            throw new IllegalArgumentException(String.format("beginning of range (%s) must come before end of range (%s)", begin, end));
        }
        this.m_begin = begin;
        this.m_end = end;
    }

    public IPAddress getBegin() {
        return this.m_begin;
    }

    public IPAddress getEnd() {
        return this.m_end;
    }

    public long size() {
        BigInteger size = this.m_end.toBigInteger();
        size = size.subtract(this.m_begin.toBigInteger());
        size = size.add(new BigInteger("1"));
        return size.longValue();
    }

    public boolean contains(IPAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException("addr should not be null");
        }
        return addr.isGreaterThanOrEqualTo(this.m_begin) && addr.isLessThanOrEqualTo(this.m_end);
    }

    public boolean contains(IPAddressRange range) {
        return this.contains(range.getBegin()) && this.contains(range.getEnd());
    }

    public boolean overlaps(IPAddressRange range) {
        return this.contains(range.getBegin()) || this.contains(range.getEnd()) || range.contains(this.getBegin()) || range.contains(this.getEnd());
    }

    public boolean comesBefore(IPAddress addr) {
        return this.m_end.isLessThan(addr);
    }

    public boolean comesBefore(IPAddressRange range) {
        return this.comesBefore(range.getBegin());
    }

    public boolean comesAfter(IPAddress addr) {
        return this.m_begin.isGreaterThan(addr);
    }

    public boolean comesAfter(IPAddressRange range) {
        return this.comesAfter(range.getEnd());
    }

    public boolean adjoins(IPAddressRange range) {
        return this.comesImmediatelyBefore(range) || this.comesImmediatelyAfter(range);
    }

    private boolean comesImmediatelyAfter(IPAddressRange range) {
        return this.comesAfter(range) && this.getBegin().isSuccessorOf(range.getEnd());
    }

    private boolean comesImmediatelyBefore(IPAddressRange range) {
        return this.comesBefore(range) && this.getEnd().isPredecessorOf(range.getBegin());
    }

    @Override
    public Iterator<IPAddress> iterator() {
        return new IPAddressRangeIterator(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPAddressRange) {
            IPAddressRange other = (IPAddressRange)obj;
            return this.m_begin.equals(other.m_begin) && this.m_end.equals(other.m_end);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.m_begin.hashCode() + this.m_end.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.m_begin).append(',').append(this.m_end).append(']');
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IPAddressRangeIterator
    implements Iterator<IPAddress> {
        private final IPAddressRange m_range;
        private IPAddress m_next;

        public IPAddressRangeIterator(IPAddressRange range) {
            this.m_range = range;
            this.m_next = range.getBegin();
        }

        @Override
        public boolean hasNext() {
            return this.m_next != null;
        }

        @Override
        public IPAddress next() {
            if (this.m_next == null) {
                throw new NoSuchElementException("Already returned the last element");
            }
            IPAddress next = this.m_next;
            this.m_next = next.incr();
            if (!this.m_range.contains(this.m_next)) {
                this.m_next = null;
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("IPAddressRangeIterator.remove() is not yet implemented");
        }
    }
}

