/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefabGraph
implements Comparable<PrefabGraph> {
    private String m_name;
    private String m_title;
    private String[] m_columns;
    private String m_command;
    private String[] m_externalValues;
    private String[] m_propertiesValues;
    private int m_order;
    private String[] m_types = new String[0];
    private String m_description;
    private Integer m_graphWidth;
    private Integer m_graphHeight;
    private String[] m_suppress;

    public PrefabGraph(String name, String title, String[] columns, String command, String[] externalValues, String[] propertiesValues, int order, String[] types, String description, Integer graphWidth, Integer graphHeight, String[] suppress) {
        Assert.notNull((Object)name, (String)"name argument cannot be null");
        Assert.notNull((Object)title, (String)"title argument cannot be null");
        Assert.notNull((Object)columns, (String)"columns argument cannot be null");
        Assert.notNull((Object)command, (String)"command argument cannot be null");
        Assert.notNull((Object)externalValues, (String)"externalValues argument cannot be null");
        Assert.notNull((Object)propertiesValues, (String)"propertiesValues argument cannot be null");
        Assert.notNull((Object)suppress, (String)"suppress argument cannot be null");
        this.m_name = name;
        this.m_title = title;
        this.m_columns = columns;
        this.m_command = command;
        this.m_externalValues = externalValues;
        this.m_propertiesValues = propertiesValues;
        this.m_order = order;
        this.m_suppress = suppress;
        this.m_types = types;
        this.m_description = description;
        this.m_graphWidth = graphWidth;
        this.m_graphHeight = graphHeight;
    }

    public String getName() {
        return this.m_name;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int getOrder() {
        return this.m_order;
    }

    public String[] getColumns() {
        return this.m_columns;
    }

    public String getCommand() {
        return this.m_command;
    }

    public String[] getExternalValues() {
        return this.m_externalValues;
    }

    public String[] getPropertiesValues() {
        return this.m_propertiesValues;
    }

    public String[] getTypes() {
        return this.m_types;
    }

    public boolean hasMatchingType(String ... matchingTypes) {
        for (String matchingType : matchingTypes) {
            for (String type : this.m_types) {
                if (type == null || !type.equals(matchingType)) continue;
                return true;
            }
        }
        return false;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Integer getGraphWidth() {
        return this.m_graphWidth;
    }

    public Integer getGraphHeight() {
        return this.m_graphHeight;
    }

    public String[] getSuppress() {
        return this.m_suppress;
    }

    @Override
    public int compareTo(PrefabGraph other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return this.getOrder() - other.getOrder();
    }
}

