/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.views;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.views.Member;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Membership
implements Serializable {
    private List<Member> _memberList = new ArrayList<Member>();

    public void addMember(Member vMember) throws IndexOutOfBoundsException {
        this._memberList.add(vMember);
    }

    public void addMember(int index, Member vMember) throws IndexOutOfBoundsException {
        this._memberList.add(index, vMember);
    }

    public Enumeration<Member> enumerateMember() {
        return Collections.enumeration(this._memberList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Membership) {
            Membership temp = (Membership)obj;
            if (this._memberList != null) {
                if (temp._memberList == null) {
                    return false;
                }
                if (!((Object)this._memberList).equals(temp._memberList)) {
                    return false;
                }
            } else if (temp._memberList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Member getMember(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._memberList.size()) {
            throw new IndexOutOfBoundsException("getMember: Index value '" + index + "' not in range [0.." + (this._memberList.size() - 1) + "]");
        }
        return this._memberList.get(index);
    }

    public Member[] getMember() {
        Member[] array = new Member[]{};
        return this._memberList.toArray(array);
    }

    public List<Member> getMemberCollection() {
        return this._memberList;
    }

    public int getMemberCount() {
        return this._memberList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._memberList != null) {
            result = 37 * result + ((Object)this._memberList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Member> iterateMember() {
        return this._memberList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllMember() {
        this._memberList.clear();
    }

    public boolean removeMember(Member vMember) {
        boolean removed = this._memberList.remove(vMember);
        return removed;
    }

    public Member removeMemberAt(int index) {
        Member obj = this._memberList.remove(index);
        return obj;
    }

    public void setMember(int index, Member vMember) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._memberList.size()) {
            throw new IndexOutOfBoundsException("setMember: Index value '" + index + "' not in range [0.." + (this._memberList.size() - 1) + "]");
        }
        this._memberList.set(index, vMember);
    }

    public void setMember(Member[] vMemberArray) {
        this._memberList.clear();
        for (int i = 0; i < vMemberArray.length; ++i) {
            this._memberList.add(vMemberArray[i]);
        }
    }

    public void setMember(List<Member> vMemberList) {
        this._memberList.clear();
        this._memberList.addAll(vMemberList);
    }

    public void setMemberCollection(List<Member> memberList) {
        this._memberList = memberList;
    }

    public static Membership unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Membership)Unmarshaller.unmarshal(Membership.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

