/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.users;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.users.Contact;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
implements Serializable {
    private boolean _readOnly = false;
    private boolean _has_readOnly;
    private String _userId;
    private String _fullName;
    private String _userComments;
    private String _password;
    private List<Contact> _contactList = new ArrayList<Contact>();
    private List<String> _dutyScheduleList = new ArrayList<String>();
    private String _tuiPin;

    public void addContact(Contact vContact) throws IndexOutOfBoundsException {
        this._contactList.add(vContact);
    }

    public void addContact(int index, Contact vContact) throws IndexOutOfBoundsException {
        this._contactList.add(index, vContact);
    }

    public void addDutySchedule(String vDutySchedule) throws IndexOutOfBoundsException {
        this._dutyScheduleList.add(vDutySchedule);
    }

    public void addDutySchedule(int index, String vDutySchedule) throws IndexOutOfBoundsException {
        this._dutyScheduleList.add(index, vDutySchedule);
    }

    public void deleteReadOnly() {
        this._has_readOnly = false;
    }

    public Enumeration<Contact> enumerateContact() {
        return Collections.enumeration(this._contactList);
    }

    public Enumeration<String> enumerateDutySchedule() {
        return Collections.enumeration(this._dutyScheduleList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof User) {
            User temp = (User)obj;
            if (this._readOnly != temp._readOnly) {
                return false;
            }
            if (this._has_readOnly != temp._has_readOnly) {
                return false;
            }
            if (this._userId != null) {
                if (temp._userId == null) {
                    return false;
                }
                if (!this._userId.equals(temp._userId)) {
                    return false;
                }
            } else if (temp._userId != null) {
                return false;
            }
            if (this._fullName != null) {
                if (temp._fullName == null) {
                    return false;
                }
                if (!this._fullName.equals(temp._fullName)) {
                    return false;
                }
            } else if (temp._fullName != null) {
                return false;
            }
            if (this._userComments != null) {
                if (temp._userComments == null) {
                    return false;
                }
                if (!this._userComments.equals(temp._userComments)) {
                    return false;
                }
            } else if (temp._userComments != null) {
                return false;
            }
            if (this._password != null) {
                if (temp._password == null) {
                    return false;
                }
                if (!this._password.equals(temp._password)) {
                    return false;
                }
            } else if (temp._password != null) {
                return false;
            }
            if (this._contactList != null) {
                if (temp._contactList == null) {
                    return false;
                }
                if (!((Object)this._contactList).equals(temp._contactList)) {
                    return false;
                }
            } else if (temp._contactList != null) {
                return false;
            }
            if (this._dutyScheduleList != null) {
                if (temp._dutyScheduleList == null) {
                    return false;
                }
                if (!((Object)this._dutyScheduleList).equals(temp._dutyScheduleList)) {
                    return false;
                }
            } else if (temp._dutyScheduleList != null) {
                return false;
            }
            if (this._tuiPin != null) {
                if (temp._tuiPin == null) {
                    return false;
                }
                if (!this._tuiPin.equals(temp._tuiPin)) {
                    return false;
                }
            } else if (temp._tuiPin != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Contact getContact(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._contactList.size()) {
            throw new IndexOutOfBoundsException("getContact: Index value '" + index + "' not in range [0.." + (this._contactList.size() - 1) + "]");
        }
        return this._contactList.get(index);
    }

    public Contact[] getContact() {
        Contact[] array = new Contact[]{};
        return this._contactList.toArray(array);
    }

    public List<Contact> getContactCollection() {
        return this._contactList;
    }

    public int getContactCount() {
        return this._contactList.size();
    }

    public String getDutySchedule(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._dutyScheduleList.size()) {
            throw new IndexOutOfBoundsException("getDutySchedule: Index value '" + index + "' not in range [0.." + (this._dutyScheduleList.size() - 1) + "]");
        }
        return this._dutyScheduleList.get(index);
    }

    public String[] getDutySchedule() {
        String[] array = new String[]{};
        return this._dutyScheduleList.toArray(array);
    }

    public List<String> getDutyScheduleCollection() {
        return this._dutyScheduleList;
    }

    public int getDutyScheduleCount() {
        return this._dutyScheduleList.size();
    }

    public String getFullName() {
        return this._fullName;
    }

    public String getPassword() {
        return this._password;
    }

    public boolean getReadOnly() {
        return this._readOnly;
    }

    public String getTuiPin() {
        return this._tuiPin;
    }

    public String getUserComments() {
        return this._userComments;
    }

    public String getUserId() {
        return this._userId;
    }

    public boolean hasReadOnly() {
        return this._has_readOnly;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this._readOnly ? 0 : 1);
        if (this._userId != null) {
            result = 37 * result + this._userId.hashCode();
        }
        if (this._fullName != null) {
            result = 37 * result + this._fullName.hashCode();
        }
        if (this._userComments != null) {
            result = 37 * result + this._userComments.hashCode();
        }
        if (this._password != null) {
            result = 37 * result + this._password.hashCode();
        }
        if (this._contactList != null) {
            result = 37 * result + ((Object)this._contactList).hashCode();
        }
        if (this._dutyScheduleList != null) {
            result = 37 * result + ((Object)this._dutyScheduleList).hashCode();
        }
        if (this._tuiPin != null) {
            result = 37 * result + this._tuiPin.hashCode();
        }
        return result;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Contact> iterateContact() {
        return this._contactList.iterator();
    }

    public Iterator<String> iterateDutySchedule() {
        return this._dutyScheduleList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllContact() {
        this._contactList.clear();
    }

    public void removeAllDutySchedule() {
        this._dutyScheduleList.clear();
    }

    public boolean removeContact(Contact vContact) {
        boolean removed = this._contactList.remove(vContact);
        return removed;
    }

    public Contact removeContactAt(int index) {
        Contact obj = this._contactList.remove(index);
        return obj;
    }

    public boolean removeDutySchedule(String vDutySchedule) {
        boolean removed = this._dutyScheduleList.remove(vDutySchedule);
        return removed;
    }

    public String removeDutyScheduleAt(int index) {
        String obj = this._dutyScheduleList.remove(index);
        return obj;
    }

    public void setContact(int index, Contact vContact) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._contactList.size()) {
            throw new IndexOutOfBoundsException("setContact: Index value '" + index + "' not in range [0.." + (this._contactList.size() - 1) + "]");
        }
        this._contactList.set(index, vContact);
    }

    public void setContact(Contact[] vContactArray) {
        this._contactList.clear();
        for (int i = 0; i < vContactArray.length; ++i) {
            this._contactList.add(vContactArray[i]);
        }
    }

    public void setContact(List<Contact> vContactList) {
        this._contactList.clear();
        this._contactList.addAll(vContactList);
    }

    public void setContactCollection(List<Contact> contactList) {
        this._contactList = contactList;
    }

    public void setDutySchedule(int index, String vDutySchedule) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._dutyScheduleList.size()) {
            throw new IndexOutOfBoundsException("setDutySchedule: Index value '" + index + "' not in range [0.." + (this._dutyScheduleList.size() - 1) + "]");
        }
        this._dutyScheduleList.set(index, vDutySchedule);
    }

    public void setDutySchedule(String[] vDutyScheduleArray) {
        this._dutyScheduleList.clear();
        for (int i = 0; i < vDutyScheduleArray.length; ++i) {
            this._dutyScheduleList.add(vDutyScheduleArray[i]);
        }
    }

    public void setDutySchedule(List<String> vDutyScheduleList) {
        this._dutyScheduleList.clear();
        this._dutyScheduleList.addAll(vDutyScheduleList);
    }

    public void setDutyScheduleCollection(List<String> dutyScheduleList) {
        this._dutyScheduleList = dutyScheduleList;
    }

    public void setFullName(String fullName) {
        this._fullName = fullName;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setReadOnly(boolean readOnly) {
        this._readOnly = readOnly;
        this._has_readOnly = true;
    }

    public void setTuiPin(String tuiPin) {
        this._tuiPin = tuiPin;
    }

    public void setUserComments(String userComments) {
        this._userComments = userComments;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    public static User unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (User)Unmarshaller.unmarshal(User.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

