/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.service.Argument;
import org.opennms.netmgt.config.service.types.InvokeAtType;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoke
implements Serializable {
    private String _method;
    private int _pass = 0;
    private boolean _has_pass;
    private InvokeAtType _at;
    private List<Argument> _argumentList = new ArrayList<Argument>();

    public void addArgument(Argument vArgument) throws IndexOutOfBoundsException {
        this._argumentList.add(vArgument);
    }

    public void addArgument(int index, Argument vArgument) throws IndexOutOfBoundsException {
        this._argumentList.add(index, vArgument);
    }

    public void deletePass() {
        this._has_pass = false;
    }

    public Enumeration<Argument> enumerateArgument() {
        return Collections.enumeration(this._argumentList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Invoke) {
            Invoke temp = (Invoke)obj;
            if (this._method != null) {
                if (temp._method == null) {
                    return false;
                }
                if (!this._method.equals(temp._method)) {
                    return false;
                }
            } else if (temp._method != null) {
                return false;
            }
            if (this._pass != temp._pass) {
                return false;
            }
            if (this._has_pass != temp._has_pass) {
                return false;
            }
            if (this._at != null) {
                if (temp._at == null) {
                    return false;
                }
                if (!this._at.equals(temp._at)) {
                    return false;
                }
            } else if (temp._at != null) {
                return false;
            }
            if (this._argumentList != null) {
                if (temp._argumentList == null) {
                    return false;
                }
                if (!((Object)this._argumentList).equals(temp._argumentList)) {
                    return false;
                }
            } else if (temp._argumentList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Argument getArgument(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._argumentList.size()) {
            throw new IndexOutOfBoundsException("getArgument: Index value '" + index + "' not in range [0.." + (this._argumentList.size() - 1) + "]");
        }
        return this._argumentList.get(index);
    }

    public Argument[] getArgument() {
        Argument[] array = new Argument[]{};
        return this._argumentList.toArray(array);
    }

    public List<Argument> getArgumentCollection() {
        return this._argumentList;
    }

    public int getArgumentCount() {
        return this._argumentList.size();
    }

    public InvokeAtType getAt() {
        return this._at;
    }

    public String getMethod() {
        return this._method;
    }

    public int getPass() {
        return this._pass;
    }

    public boolean hasPass() {
        return this._has_pass;
    }

    public int hashCode() {
        int result = 17;
        if (this._method != null) {
            result = 37 * result + this._method.hashCode();
        }
        result = 37 * result + this._pass;
        if (this._at != null) {
            result = 37 * result + this._at.hashCode();
        }
        if (this._argumentList != null) {
            result = 37 * result + ((Object)this._argumentList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Argument> iterateArgument() {
        return this._argumentList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllArgument() {
        this._argumentList.clear();
    }

    public boolean removeArgument(Argument vArgument) {
        boolean removed = this._argumentList.remove(vArgument);
        return removed;
    }

    public Argument removeArgumentAt(int index) {
        Argument obj = this._argumentList.remove(index);
        return obj;
    }

    public void setArgument(int index, Argument vArgument) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._argumentList.size()) {
            throw new IndexOutOfBoundsException("setArgument: Index value '" + index + "' not in range [0.." + (this._argumentList.size() - 1) + "]");
        }
        this._argumentList.set(index, vArgument);
    }

    public void setArgument(Argument[] vArgumentArray) {
        this._argumentList.clear();
        for (int i = 0; i < vArgumentArray.length; ++i) {
            this._argumentList.add(vArgumentArray[i]);
        }
    }

    public void setArgument(List<Argument> vArgumentList) {
        this._argumentList.clear();
        this._argumentList.addAll(vArgumentList);
    }

    public void setArgumentCollection(List<Argument> argumentList) {
        this._argumentList = argumentList;
    }

    public void setAt(InvokeAtType at) {
        this._at = at;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setPass(int pass) {
        this._pass = pass;
        this._has_pass = true;
    }

    public static Invoke unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Invoke)Unmarshaller.unmarshal(Invoke.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

