/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoAcknowledge
implements Serializable {
    private String _resolutionPrefix = "RESOLVED: ";
    private String _uei;
    private String _acknowledge;
    private boolean _notify = true;
    private boolean _has_notify;
    private List<String> _matchList;

    public AutoAcknowledge() {
        this.setResolutionPrefix("RESOLVED: ");
        this._matchList = new ArrayList<String>();
    }

    public void addMatch(String vMatch) throws IndexOutOfBoundsException {
        this._matchList.add(vMatch);
    }

    public void addMatch(int index, String vMatch) throws IndexOutOfBoundsException {
        this._matchList.add(index, vMatch);
    }

    public void deleteNotify() {
        this._has_notify = false;
    }

    public Enumeration<String> enumerateMatch() {
        return Collections.enumeration(this._matchList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AutoAcknowledge) {
            AutoAcknowledge temp = (AutoAcknowledge)obj;
            if (this._resolutionPrefix != null) {
                if (temp._resolutionPrefix == null) {
                    return false;
                }
                if (!this._resolutionPrefix.equals(temp._resolutionPrefix)) {
                    return false;
                }
            } else if (temp._resolutionPrefix != null) {
                return false;
            }
            if (this._uei != null) {
                if (temp._uei == null) {
                    return false;
                }
                if (!this._uei.equals(temp._uei)) {
                    return false;
                }
            } else if (temp._uei != null) {
                return false;
            }
            if (this._acknowledge != null) {
                if (temp._acknowledge == null) {
                    return false;
                }
                if (!this._acknowledge.equals(temp._acknowledge)) {
                    return false;
                }
            } else if (temp._acknowledge != null) {
                return false;
            }
            if (this._notify != temp._notify) {
                return false;
            }
            if (this._has_notify != temp._has_notify) {
                return false;
            }
            if (this._matchList != null) {
                if (temp._matchList == null) {
                    return false;
                }
                if (!((Object)this._matchList).equals(temp._matchList)) {
                    return false;
                }
            } else if (temp._matchList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getAcknowledge() {
        return this._acknowledge;
    }

    public String getMatch(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._matchList.size()) {
            throw new IndexOutOfBoundsException("getMatch: Index value '" + index + "' not in range [0.." + (this._matchList.size() - 1) + "]");
        }
        return this._matchList.get(index);
    }

    public String[] getMatch() {
        String[] array = new String[]{};
        return this._matchList.toArray(array);
    }

    public List<String> getMatchCollection() {
        return this._matchList;
    }

    public int getMatchCount() {
        return this._matchList.size();
    }

    public boolean getNotify() {
        return this._notify;
    }

    public String getResolutionPrefix() {
        return this._resolutionPrefix;
    }

    public String getUei() {
        return this._uei;
    }

    public boolean hasNotify() {
        return this._has_notify;
    }

    public int hashCode() {
        int result = 17;
        if (this._resolutionPrefix != null) {
            result = 37 * result + this._resolutionPrefix.hashCode();
        }
        if (this._uei != null) {
            result = 37 * result + this._uei.hashCode();
        }
        if (this._acknowledge != null) {
            result = 37 * result + this._acknowledge.hashCode();
        }
        result = 37 * result + (this._notify ? 0 : 1);
        if (this._matchList != null) {
            result = 37 * result + ((Object)this._matchList).hashCode();
        }
        return result;
    }

    public boolean isNotify() {
        return this._notify;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateMatch() {
        return this._matchList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllMatch() {
        this._matchList.clear();
    }

    public boolean removeMatch(String vMatch) {
        boolean removed = this._matchList.remove(vMatch);
        return removed;
    }

    public String removeMatchAt(int index) {
        String obj = this._matchList.remove(index);
        return obj;
    }

    public void setAcknowledge(String acknowledge) {
        this._acknowledge = acknowledge;
    }

    public void setMatch(int index, String vMatch) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._matchList.size()) {
            throw new IndexOutOfBoundsException("setMatch: Index value '" + index + "' not in range [0.." + (this._matchList.size() - 1) + "]");
        }
        this._matchList.set(index, vMatch);
    }

    public void setMatch(String[] vMatchArray) {
        this._matchList.clear();
        for (int i = 0; i < vMatchArray.length; ++i) {
            this._matchList.add(vMatchArray[i]);
        }
    }

    public void setMatch(List<String> vMatchList) {
        this._matchList.clear();
        this._matchList.addAll(vMatchList);
    }

    public void setMatchCollection(List<String> matchList) {
        this._matchList = matchList;
    }

    public void setNotify(boolean notify) {
        this._notify = notify;
        this._has_notify = true;
    }

    public void setResolutionPrefix(String resolutionPrefix) {
        this._resolutionPrefix = resolutionPrefix;
    }

    public void setUei(String uei) {
        this._uei = uei;
    }

    public static AutoAcknowledge unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (AutoAcknowledge)Unmarshaller.unmarshal(AutoAcknowledge.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

