/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.charts;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.charts.ChartBackgroundColor;
import org.opennms.netmgt.config.charts.GridLines;
import org.opennms.netmgt.config.charts.ImageSize;
import org.opennms.netmgt.config.charts.PlotBackgroundColor;
import org.opennms.netmgt.config.charts.SeriesDef;
import org.opennms.netmgt.config.charts.SubTitle;
import org.opennms.netmgt.config.charts.Title;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarChart
implements Serializable {
    private String _name;
    private String _domainAxisLabel;
    private String _rangeAxisLabel;
    private String _subLabelClass;
    private String _seriesColorClass;
    private boolean _drawBarOutline = true;
    private boolean _has_drawBarOutline;
    private boolean _showLegend = true;
    private boolean _has_showLegend;
    private boolean _showToolTips = false;
    private boolean _has_showToolTips;
    private boolean _showUrls = false;
    private boolean _has_showUrls;
    private String _variation;
    private String _plotOrientation;
    private Title _title;
    private ImageSize _imageSize;
    private List<SubTitle> _subTitleList = new ArrayList<SubTitle>();
    private GridLines _gridLines;
    private List<SeriesDef> _seriesDefList = new ArrayList<SeriesDef>();
    private PlotBackgroundColor _plotBackgroundColor;
    private ChartBackgroundColor _chartBackgroundColor;

    public void addSeriesDef(SeriesDef vSeriesDef) throws IndexOutOfBoundsException {
        this._seriesDefList.add(vSeriesDef);
    }

    public void addSeriesDef(int index, SeriesDef vSeriesDef) throws IndexOutOfBoundsException {
        this._seriesDefList.add(index, vSeriesDef);
    }

    public void addSubTitle(SubTitle vSubTitle) throws IndexOutOfBoundsException {
        this._subTitleList.add(vSubTitle);
    }

    public void addSubTitle(int index, SubTitle vSubTitle) throws IndexOutOfBoundsException {
        this._subTitleList.add(index, vSubTitle);
    }

    public void deleteDrawBarOutline() {
        this._has_drawBarOutline = false;
    }

    public void deleteShowLegend() {
        this._has_showLegend = false;
    }

    public void deleteShowToolTips() {
        this._has_showToolTips = false;
    }

    public void deleteShowUrls() {
        this._has_showUrls = false;
    }

    public Enumeration<SeriesDef> enumerateSeriesDef() {
        return Collections.enumeration(this._seriesDefList);
    }

    public Enumeration<SubTitle> enumerateSubTitle() {
        return Collections.enumeration(this._subTitleList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BarChart) {
            BarChart temp = (BarChart)obj;
            if (this._name != null) {
                if (temp._name == null) {
                    return false;
                }
                if (!this._name.equals(temp._name)) {
                    return false;
                }
            } else if (temp._name != null) {
                return false;
            }
            if (this._domainAxisLabel != null) {
                if (temp._domainAxisLabel == null) {
                    return false;
                }
                if (!this._domainAxisLabel.equals(temp._domainAxisLabel)) {
                    return false;
                }
            } else if (temp._domainAxisLabel != null) {
                return false;
            }
            if (this._rangeAxisLabel != null) {
                if (temp._rangeAxisLabel == null) {
                    return false;
                }
                if (!this._rangeAxisLabel.equals(temp._rangeAxisLabel)) {
                    return false;
                }
            } else if (temp._rangeAxisLabel != null) {
                return false;
            }
            if (this._subLabelClass != null) {
                if (temp._subLabelClass == null) {
                    return false;
                }
                if (!this._subLabelClass.equals(temp._subLabelClass)) {
                    return false;
                }
            } else if (temp._subLabelClass != null) {
                return false;
            }
            if (this._seriesColorClass != null) {
                if (temp._seriesColorClass == null) {
                    return false;
                }
                if (!this._seriesColorClass.equals(temp._seriesColorClass)) {
                    return false;
                }
            } else if (temp._seriesColorClass != null) {
                return false;
            }
            if (this._drawBarOutline != temp._drawBarOutline) {
                return false;
            }
            if (this._has_drawBarOutline != temp._has_drawBarOutline) {
                return false;
            }
            if (this._showLegend != temp._showLegend) {
                return false;
            }
            if (this._has_showLegend != temp._has_showLegend) {
                return false;
            }
            if (this._showToolTips != temp._showToolTips) {
                return false;
            }
            if (this._has_showToolTips != temp._has_showToolTips) {
                return false;
            }
            if (this._showUrls != temp._showUrls) {
                return false;
            }
            if (this._has_showUrls != temp._has_showUrls) {
                return false;
            }
            if (this._variation != null) {
                if (temp._variation == null) {
                    return false;
                }
                if (!this._variation.equals(temp._variation)) {
                    return false;
                }
            } else if (temp._variation != null) {
                return false;
            }
            if (this._plotOrientation != null) {
                if (temp._plotOrientation == null) {
                    return false;
                }
                if (!this._plotOrientation.equals(temp._plotOrientation)) {
                    return false;
                }
            } else if (temp._plotOrientation != null) {
                return false;
            }
            if (this._title != null) {
                if (temp._title == null) {
                    return false;
                }
                if (!this._title.equals(temp._title)) {
                    return false;
                }
            } else if (temp._title != null) {
                return false;
            }
            if (this._imageSize != null) {
                if (temp._imageSize == null) {
                    return false;
                }
                if (!this._imageSize.equals(temp._imageSize)) {
                    return false;
                }
            } else if (temp._imageSize != null) {
                return false;
            }
            if (this._subTitleList != null) {
                if (temp._subTitleList == null) {
                    return false;
                }
                if (!((Object)this._subTitleList).equals(temp._subTitleList)) {
                    return false;
                }
            } else if (temp._subTitleList != null) {
                return false;
            }
            if (this._gridLines != null) {
                if (temp._gridLines == null) {
                    return false;
                }
                if (!this._gridLines.equals(temp._gridLines)) {
                    return false;
                }
            } else if (temp._gridLines != null) {
                return false;
            }
            if (this._seriesDefList != null) {
                if (temp._seriesDefList == null) {
                    return false;
                }
                if (!((Object)this._seriesDefList).equals(temp._seriesDefList)) {
                    return false;
                }
            } else if (temp._seriesDefList != null) {
                return false;
            }
            if (this._plotBackgroundColor != null) {
                if (temp._plotBackgroundColor == null) {
                    return false;
                }
                if (!this._plotBackgroundColor.equals(temp._plotBackgroundColor)) {
                    return false;
                }
            } else if (temp._plotBackgroundColor != null) {
                return false;
            }
            if (this._chartBackgroundColor != null) {
                if (temp._chartBackgroundColor == null) {
                    return false;
                }
                if (!this._chartBackgroundColor.equals(temp._chartBackgroundColor)) {
                    return false;
                }
            } else if (temp._chartBackgroundColor != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public ChartBackgroundColor getChartBackgroundColor() {
        return this._chartBackgroundColor;
    }

    public String getDomainAxisLabel() {
        return this._domainAxisLabel;
    }

    public boolean getDrawBarOutline() {
        return this._drawBarOutline;
    }

    public GridLines getGridLines() {
        return this._gridLines;
    }

    public ImageSize getImageSize() {
        return this._imageSize;
    }

    public String getName() {
        return this._name;
    }

    public PlotBackgroundColor getPlotBackgroundColor() {
        return this._plotBackgroundColor;
    }

    public String getPlotOrientation() {
        return this._plotOrientation;
    }

    public String getRangeAxisLabel() {
        return this._rangeAxisLabel;
    }

    public String getSeriesColorClass() {
        return this._seriesColorClass;
    }

    public SeriesDef getSeriesDef(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._seriesDefList.size()) {
            throw new IndexOutOfBoundsException("getSeriesDef: Index value '" + index + "' not in range [0.." + (this._seriesDefList.size() - 1) + "]");
        }
        return this._seriesDefList.get(index);
    }

    public SeriesDef[] getSeriesDef() {
        SeriesDef[] array = new SeriesDef[]{};
        return this._seriesDefList.toArray(array);
    }

    public List<SeriesDef> getSeriesDefCollection() {
        return this._seriesDefList;
    }

    public int getSeriesDefCount() {
        return this._seriesDefList.size();
    }

    public boolean getShowLegend() {
        return this._showLegend;
    }

    public boolean getShowToolTips() {
        return this._showToolTips;
    }

    public boolean getShowUrls() {
        return this._showUrls;
    }

    public String getSubLabelClass() {
        return this._subLabelClass;
    }

    public SubTitle getSubTitle(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._subTitleList.size()) {
            throw new IndexOutOfBoundsException("getSubTitle: Index value '" + index + "' not in range [0.." + (this._subTitleList.size() - 1) + "]");
        }
        return this._subTitleList.get(index);
    }

    public SubTitle[] getSubTitle() {
        SubTitle[] array = new SubTitle[]{};
        return this._subTitleList.toArray(array);
    }

    public List<SubTitle> getSubTitleCollection() {
        return this._subTitleList;
    }

    public int getSubTitleCount() {
        return this._subTitleList.size();
    }

    public Title getTitle() {
        return this._title;
    }

    public String getVariation() {
        return this._variation;
    }

    public boolean hasDrawBarOutline() {
        return this._has_drawBarOutline;
    }

    public boolean hasShowLegend() {
        return this._has_showLegend;
    }

    public boolean hasShowToolTips() {
        return this._has_showToolTips;
    }

    public boolean hasShowUrls() {
        return this._has_showUrls;
    }

    public int hashCode() {
        int result = 17;
        if (this._name != null) {
            result = 37 * result + this._name.hashCode();
        }
        if (this._domainAxisLabel != null) {
            result = 37 * result + this._domainAxisLabel.hashCode();
        }
        if (this._rangeAxisLabel != null) {
            result = 37 * result + this._rangeAxisLabel.hashCode();
        }
        if (this._subLabelClass != null) {
            result = 37 * result + this._subLabelClass.hashCode();
        }
        if (this._seriesColorClass != null) {
            result = 37 * result + this._seriesColorClass.hashCode();
        }
        result = 37 * result + (this._drawBarOutline ? 0 : 1);
        result = 37 * result + (this._showLegend ? 0 : 1);
        result = 37 * result + (this._showToolTips ? 0 : 1);
        result = 37 * result + (this._showUrls ? 0 : 1);
        if (this._variation != null) {
            result = 37 * result + this._variation.hashCode();
        }
        if (this._plotOrientation != null) {
            result = 37 * result + this._plotOrientation.hashCode();
        }
        if (this._title != null) {
            result = 37 * result + this._title.hashCode();
        }
        if (this._imageSize != null) {
            result = 37 * result + this._imageSize.hashCode();
        }
        if (this._subTitleList != null) {
            result = 37 * result + ((Object)this._subTitleList).hashCode();
        }
        if (this._gridLines != null) {
            result = 37 * result + this._gridLines.hashCode();
        }
        if (this._seriesDefList != null) {
            result = 37 * result + ((Object)this._seriesDefList).hashCode();
        }
        if (this._plotBackgroundColor != null) {
            result = 37 * result + this._plotBackgroundColor.hashCode();
        }
        if (this._chartBackgroundColor != null) {
            result = 37 * result + this._chartBackgroundColor.hashCode();
        }
        return result;
    }

    public boolean isDrawBarOutline() {
        return this._drawBarOutline;
    }

    public boolean isShowLegend() {
        return this._showLegend;
    }

    public boolean isShowToolTips() {
        return this._showToolTips;
    }

    public boolean isShowUrls() {
        return this._showUrls;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<SeriesDef> iterateSeriesDef() {
        return this._seriesDefList.iterator();
    }

    public Iterator<SubTitle> iterateSubTitle() {
        return this._subTitleList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllSeriesDef() {
        this._seriesDefList.clear();
    }

    public void removeAllSubTitle() {
        this._subTitleList.clear();
    }

    public boolean removeSeriesDef(SeriesDef vSeriesDef) {
        boolean removed = this._seriesDefList.remove(vSeriesDef);
        return removed;
    }

    public SeriesDef removeSeriesDefAt(int index) {
        SeriesDef obj = this._seriesDefList.remove(index);
        return obj;
    }

    public boolean removeSubTitle(SubTitle vSubTitle) {
        boolean removed = this._subTitleList.remove(vSubTitle);
        return removed;
    }

    public SubTitle removeSubTitleAt(int index) {
        SubTitle obj = this._subTitleList.remove(index);
        return obj;
    }

    public void setChartBackgroundColor(ChartBackgroundColor chartBackgroundColor) {
        this._chartBackgroundColor = chartBackgroundColor;
    }

    public void setDomainAxisLabel(String domainAxisLabel) {
        this._domainAxisLabel = domainAxisLabel;
    }

    public void setDrawBarOutline(boolean drawBarOutline) {
        this._drawBarOutline = drawBarOutline;
        this._has_drawBarOutline = true;
    }

    public void setGridLines(GridLines gridLines) {
        this._gridLines = gridLines;
    }

    public void setImageSize(ImageSize imageSize) {
        this._imageSize = imageSize;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPlotBackgroundColor(PlotBackgroundColor plotBackgroundColor) {
        this._plotBackgroundColor = plotBackgroundColor;
    }

    public void setPlotOrientation(String plotOrientation) {
        this._plotOrientation = plotOrientation;
    }

    public void setRangeAxisLabel(String rangeAxisLabel) {
        this._rangeAxisLabel = rangeAxisLabel;
    }

    public void setSeriesColorClass(String seriesColorClass) {
        this._seriesColorClass = seriesColorClass;
    }

    public void setSeriesDef(int index, SeriesDef vSeriesDef) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._seriesDefList.size()) {
            throw new IndexOutOfBoundsException("setSeriesDef: Index value '" + index + "' not in range [0.." + (this._seriesDefList.size() - 1) + "]");
        }
        this._seriesDefList.set(index, vSeriesDef);
    }

    public void setSeriesDef(SeriesDef[] vSeriesDefArray) {
        this._seriesDefList.clear();
        for (int i = 0; i < vSeriesDefArray.length; ++i) {
            this._seriesDefList.add(vSeriesDefArray[i]);
        }
    }

    public void setSeriesDef(List<SeriesDef> vSeriesDefList) {
        this._seriesDefList.clear();
        this._seriesDefList.addAll(vSeriesDefList);
    }

    public void setSeriesDefCollection(List<SeriesDef> seriesDefList) {
        this._seriesDefList = seriesDefList;
    }

    public void setShowLegend(boolean showLegend) {
        this._showLegend = showLegend;
        this._has_showLegend = true;
    }

    public void setShowToolTips(boolean showToolTips) {
        this._showToolTips = showToolTips;
        this._has_showToolTips = true;
    }

    public void setShowUrls(boolean showUrls) {
        this._showUrls = showUrls;
        this._has_showUrls = true;
    }

    public void setSubLabelClass(String subLabelClass) {
        this._subLabelClass = subLabelClass;
    }

    public void setSubTitle(int index, SubTitle vSubTitle) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._subTitleList.size()) {
            throw new IndexOutOfBoundsException("setSubTitle: Index value '" + index + "' not in range [0.." + (this._subTitleList.size() - 1) + "]");
        }
        this._subTitleList.set(index, vSubTitle);
    }

    public void setSubTitle(SubTitle[] vSubTitleArray) {
        this._subTitleList.clear();
        for (int i = 0; i < vSubTitleArray.length; ++i) {
            this._subTitleList.add(vSubTitleArray[i]);
        }
    }

    public void setSubTitle(List<SubTitle> vSubTitleList) {
        this._subTitleList.clear();
        this._subTitleList.addAll(vSubTitleList);
    }

    public void setSubTitleCollection(List<SubTitle> subTitleList) {
        this._subTitleList = subTitleList;
    }

    public void setTitle(Title title) {
        this._title = title;
    }

    public void setVariation(String variation) {
        this._variation = variation;
    }

    public static BarChart unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (BarChart)Unmarshaller.unmarshal(BarChart.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

